/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Map;
import java.util.Optional;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.oid4vci.CredentialScopeModel;
import org.keycloak.protocol.oid4vc.model.AttestationProof;
import org.keycloak.protocol.oid4vc.model.CredentialDefinition;
import org.keycloak.protocol.oid4vc.model.CredentialResponseEncryption;
import org.keycloak.protocol.oid4vc.model.JwtProof;
import org.keycloak.protocol.oid4vc.model.Proofs;
import org.keycloak.util.JsonSerialization;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CredentialRequest {
    @JsonProperty(value="credential_configuration_id")
    private String credentialConfigurationId;
    @JsonProperty(value="credential_identifier")
    private String credentialIdentifier;
    @JsonProperty(value="proofs")
    private Proofs proofs;
    @Deprecated
    @JsonProperty(value="proof")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="proof_type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=JwtProof.class, name="jwt"), @JsonSubTypes.Type(value=AttestationProof.class, name="attestation")})
    private Object proof;
    @JsonProperty(value="credential_definition")
    private CredentialDefinition credentialDefinition;
    @JsonProperty(value="credential_response_encryption")
    private CredentialResponseEncryption credentialResponseEncryption;

    public String getCredentialIdentifier() {
        return this.credentialIdentifier;
    }

    public CredentialRequest setCredentialIdentifier(String credentialIdentifier) {
        this.credentialIdentifier = credentialIdentifier;
        return this;
    }

    public String getCredentialConfigurationId() {
        return this.credentialConfigurationId;
    }

    public CredentialRequest setCredentialConfigurationId(String credentialConfigurationId) {
        this.credentialConfigurationId = credentialConfigurationId;
        return this;
    }

    public Proofs getProofs() {
        return this.proofs;
    }

    public CredentialRequest setProofs(Proofs proofs) {
        this.proofs = proofs;
        return this;
    }

    public Object getProof() {
        return this.proof;
    }

    public CredentialRequest setProof(Object proof) {
        this.proof = proof;
        return this;
    }

    public CredentialDefinition getCredentialDefinition() {
        return this.credentialDefinition;
    }

    public CredentialRequest setCredentialDefinition(CredentialDefinition credentialDefinition) {
        this.credentialDefinition = credentialDefinition;
        return this;
    }

    public CredentialResponseEncryption getCredentialResponseEncryption() {
        return this.credentialResponseEncryption;
    }

    public CredentialRequest setCredentialResponseEncryption(CredentialResponseEncryption credentialResponseEncryption) {
        this.credentialResponseEncryption = credentialResponseEncryption;
        return this;
    }

    public Optional<CredentialScopeModel> findCredentialScope(KeycloakSession keycloakSession) {
        Map searchAttributeMap = Optional.ofNullable(this.credentialConfigurationId).map(credentialIdentifier -> Map.of("vc.credential_configuration_id", this.credentialConfigurationId)).orElseGet(() -> Map.of("vc.credential_identifier", this.credentialIdentifier));
        RealmModel currentRealm = keycloakSession.getContext().getRealm();
        boolean useOrExpression = false;
        return keycloakSession.clientScopes().getClientScopesByAttributes(currentRealm, searchAttributeMap, false).map(CredentialScopeModel::new).findAny();
    }

    public String toString() {
        try {
            return JsonSerialization.mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

