/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.github.resilience4j.micrometer.tagged.ThreadPoolBulkheadMetricNames;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

abstract class AbstractThreadPoolBulkheadMetrics
extends AbstractMetrics {
    protected final ThreadPoolBulkheadMetricNames names;

    protected AbstractThreadPoolBulkheadMetrics(ThreadPoolBulkheadMetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    @Deprecated
    protected AbstractThreadPoolBulkheadMetrics(MetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    protected void addMetrics(MeterRegistry meterRegistry, ThreadPoolBulkhead bulkhead) {
        List<Tag> customTags = this.mapToTagsList(bulkhead.getTags().toJavaMap());
        this.registerMetrics(meterRegistry, bulkhead, customTags);
    }

    private void registerMetrics(MeterRegistry meterRegistry, ThreadPoolBulkhead bulkhead, List<Tag> customTags) {
        this.removeMetrics(meterRegistry, bulkhead.getName());
        HashSet<Meter.Id> idSet = new HashSet<Meter.Id>();
        idSet.add(Gauge.builder((String)this.names.getQueueDepthMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getQueueDepth()).description("The queue depth").tag("name", bulkhead.getName()).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getThreadPoolSizeMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getThreadPoolSize()).description("The thread pool size").tag("name", bulkhead.getName()).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getQueueCapacityMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getQueueCapacity()).description("The queue capacity").tag("name", bulkhead.getName()).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getMaxThreadPoolSizeMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getMaximumThreadPoolSize()).description("The maximum thread pool size").tag("name", bulkhead.getName()).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getCoreThreadPoolSizeMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getCoreThreadPoolSize()).description("The core thread pool size").tag("name", bulkhead.getName()).tags(customTags).register(meterRegistry).getId());
        this.meterIdMap.put(bulkhead.getName(), idSet);
    }

    @Deprecated
    public static class MetricNames
    extends ThreadPoolBulkheadMetricNames {
    }
}

