/*
 * Decompiled with CFR 0.152.
 */
package waffle.windows.auth.impl;

import com.sun.jna.platform.win32.Netapi32Util;
import waffle.windows.auth.IWindowsDomain;

public class WindowsDomainImpl
implements IWindowsDomain {
    private String fqn;
    private TrustDirection trustDirection = TrustDirection.BIDIRECTIONAL;
    private TrustType trustType = TrustType.UNKNOWN;

    public WindowsDomainImpl(String newFqn) {
        this.fqn = newFqn;
    }

    public WindowsDomainImpl(Netapi32Util.DomainTrust trust) {
        this.fqn = trust.DnsDomainName;
        if (this.fqn == null || this.fqn.length() == 0) {
            this.fqn = trust.NetbiosDomainName;
        }
        if (trust.isInbound() && trust.isOutbound()) {
            this.trustDirection = TrustDirection.BIDIRECTIONAL;
        } else if (trust.isOutbound()) {
            this.trustDirection = TrustDirection.OUTBOUND;
        } else if (trust.isInbound()) {
            this.trustDirection = TrustDirection.INBOUND;
        }
        if (trust.isInForest()) {
            this.trustType = TrustType.FOREST;
        } else if (trust.isRoot()) {
            this.trustType = TrustType.TREE_ROOT;
        }
    }

    @Override
    public String getFqn() {
        return this.fqn;
    }

    @Override
    public String getTrustDirectionString() {
        return this.trustDirection.toString();
    }

    @Override
    public String getTrustTypeString() {
        return this.trustType.toString();
    }

    private static enum TrustDirection {
        INBOUND,
        OUTBOUND,
        BIDIRECTIONAL;

    }

    private static enum TrustType {
        TREE_ROOT,
        PARENT_CHILD,
        CROSS_LINK,
        EXTERNAL,
        FOREST,
        KERBEROS,
        UNKNOWN;

    }
}

