/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class Slice extends Base {

	public Slice(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Set all vertices of a slice. All polygons will be cleared.
	 *
	 * @param vertices contains the positions.
	 * @throws Lib3MFException
	 */
	public void setVertices(Position2D[] vertices) throws Lib3MFException {
		Pointer bufferVertices = new Memory(Math.max(1, Position2D.SIZE * vertices.length));
		for (int i = 0; i < vertices.length; i++) {
		  vertices[i].writeToPointer(bufferVertices, i * Position2D.SIZE);
		}
		mWrapper.checkError(this, mWrapper.lib3mf_slice_setvertices.invokeInt(new java.lang.Object[]{mHandle, (long) vertices.length, bufferVertices}));
	}

	/**
	 * Get all vertices of a slice
	 *
	 * @return contains the positions.
	 * @throws Lib3MFException
	 */
	public Position2D[] getVertices() throws Lib3MFException {
		Pointer countNeededVertices = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_slice_getvertices.invokeInt(new java.lang.Object[]{mHandle, 0L, countNeededVertices, null}));
		long countVertices = countNeededVertices.getLong(0);
		Pointer bufferVertices = new Memory(Math.max(1, countVertices * Position2D.SIZE));
		mWrapper.checkError(this, mWrapper.lib3mf_slice_getvertices.invokeInt(new java.lang.Object[]{mHandle, countVertices, countNeededVertices, bufferVertices}));
		Position2D vertices[] = new Position2D[(int)countVertices];
		for (int i = 0; i < (int)countVertices; i++) {
		  vertices[i] = new Position2D();
		  vertices[i].readFromPointer(bufferVertices, i * Position2D.SIZE);
		}
		return vertices;
	}

	/**
	 * Get the number of vertices in a slice
	 *
	 * @return the number of vertices in the slice
	 * @throws Lib3MFException
	 */
	public long getVertexCount() throws Lib3MFException {
		Pointer bufferCount = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_slice_getvertexcount.invokeInt(new java.lang.Object[]{mHandle, bufferCount}));
		return bufferCount.getLong(0);
	}

	/**
	 * Add a new polygon to this slice
	 *
	 * @param indices the new indices of the new polygon
	 * @return the index of the new polygon
	 * @throws Lib3MFException
	 */
	public long addPolygon(int[] indices) throws Lib3MFException {
		Pointer bufferIndices = new Memory(Math.max(1, 4 * indices.length));
		for (int i = 0; i < indices.length; i++) {
		  bufferIndices.setInt(4 * i, indices[i]);
		}
		Pointer bufferIndex = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_slice_addpolygon.invokeInt(new java.lang.Object[]{mHandle, (long) indices.length, bufferIndices, bufferIndex}));
		return bufferIndex.getLong(0);
	}

	/**
	 * Get the number of polygons in the slice
	 *
	 * @return the number of polygons in the slice
	 * @throws Lib3MFException
	 */
	public long getPolygonCount() throws Lib3MFException {
		Pointer bufferCount = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_slice_getpolygoncount.invokeInt(new java.lang.Object[]{mHandle, bufferCount}));
		return bufferCount.getLong(0);
	}

	/**
	 * Set all indices of a polygon
	 *
	 * @param index the index of the polygon to manipulate
	 * @param indices the new indices of the index-th polygon
	 * @throws Lib3MFException
	 */
	public void setPolygonIndices(long index, int[] indices) throws Lib3MFException {
		Pointer bufferIndices = new Memory(Math.max(1, 4 * indices.length));
		for (int i = 0; i < indices.length; i++) {
		  bufferIndices.setInt(4 * i, indices[i]);
		}
		mWrapper.checkError(this, mWrapper.lib3mf_slice_setpolygonindices.invokeInt(new java.lang.Object[]{mHandle, index, (long) indices.length, bufferIndices}));
	}

	/**
	 * Get all vertices of a slice
	 *
	 * @param index the index of the polygon to manipulate
	 * @return the indices of the index-th polygon 
	 * @throws Lib3MFException
	 */
	public int[] getPolygonIndices(long index) throws Lib3MFException {
		Pointer countNeededIndices = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_slice_getpolygonindices.invokeInt(new java.lang.Object[]{mHandle, index, 0L, countNeededIndices, Pointer.NULL}));
		long countIndices = countNeededIndices.getLong(0);
		Pointer bufferIndices = new Memory(Math.max(1, 4 * countIndices));
		mWrapper.checkError(this, mWrapper.lib3mf_slice_getpolygonindices.invokeInt(new java.lang.Object[]{mHandle, index, countIndices, countNeededIndices, bufferIndices}));
		return bufferIndices.getIntArray(0, (int)countIndices);
	}

	/**
	 * Get the number of vertices in a slice
	 *
	 * @param index the index of the polygon to manipulate
	 * @return the number of indices of the index-th polygon
	 * @throws Lib3MFException
	 */
	public long getPolygonIndexCount(long index) throws Lib3MFException {
		Pointer bufferCount = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_slice_getpolygonindexcount.invokeInt(new java.lang.Object[]{mHandle, index, bufferCount}));
		return bufferCount.getLong(0);
	}

	/**
	 * Get the upper Z-Coordinate of this slice.
	 *
	 * @return the upper Z-Coordinate of this slice
	 * @throws Lib3MFException
	 */
	public double getZTop() throws Lib3MFException {
		Pointer bufferZTop = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_slice_getztop.invokeInt(new java.lang.Object[]{mHandle, bufferZTop}));
		return bufferZTop.getDouble(0);
	}


}

