/// <reference types="node" />
/// <reference types="node" />
import { webcrypto } from 'node:crypto';
import { Request, Response, default as express } from 'express';
import { MatrixClient } from '@vector-im/matrix-bot-sdk';
interface MediaMetadata {
    endDt?: number;
    mxc: string;
}
interface Opts {
    publicUrl: URL;
    ttl?: number;
    signingKey: webcrypto.CryptoKey;
}
/**
 * A media proxy class intended for bridges which share media to the
 * public internet.
 */
export declare class MediaProxy {
    private readonly opts;
    private readonly matrixClient;
    private readonly internalRouter;
    /**
     * Only used if start() is called.
     */
    private server?;
    /**
     * Get the express router used for handling calls.
     */
    get router(): express.Router;
    constructor(opts: Opts, matrixClient: MatrixClient);
    start(port: number, hostname?: string, backlog?: number): Promise<void>;
    close(): Promise<void>;
    getMediaToken(metadata: MediaMetadata): Promise<string>;
    verifyMediaToken(token: string): Promise<MediaMetadata>;
    generateMediaUrl(mxc: string): Promise<URL>;
    onMediaRequest(req: Request, res: Response): Promise<void>;
    private getHealth;
    private onError;
}
export {};
