/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.NoSuchElementException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mediathek.config.Daten;
import mediathek.filmlisten.FilmeLaden;
import mediathek.gui.actions.DisposeDialogAction;
import mediathek.gui.dialog.ButtonFlowPanel;
import mediathek.gui.dialog.ButtonPanel;
import mediathek.gui.dialogEinstellungen.PanelFilmlisteLaden;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.FilmListUpdateType;
import mediathek.tool.GuiFunktionen;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmediathek/gui/dialog/LoadFilmListDialog;", "Ljavax/swing/JDialog;", "owner", "Ljava/awt/Frame;", "<init>", "(Ljava/awt/Frame;)V", "contentPanel", "Lmediathek/gui/dialogEinstellungen/PanelFilmlisteLaden;", "logger", "Lorg/apache/logging/log4j/Logger;", "btnContentPanel", "Lmediathek/gui/dialog/ButtonPanel;", "createButtonPanel", "", "restoreWindowSizeFromConfig", "registerWindowSizeListener", "MediathekView"})
public final class LoadFilmListDialog
extends JDialog {
    @NotNull
    private final PanelFilmlisteLaden contentPanel;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ButtonPanel btnContentPanel;

    public LoadFilmListDialog(@Nullable Frame owner) {
        super(owner, "Filmliste laden", true);
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.btnContentPanel = new ButtonPanel();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel = new PanelFilmlisteLaden(false);
        JScrollPane scrollPane = new JScrollPane(this.contentPanel);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.createButtonPanel();
        this.getContentPane().add((Component)this.btnContentPanel, "South");
        this.restoreWindowSizeFromConfig();
        this.registerWindowSizeListener();
        EscapeKeyHandler.installHandler(this, () -> LoadFilmListDialog._init_$lambda$0(this));
    }

    private final void createButtonPanel() {
        ButtonFlowPanel buttonFlowPanel = new ButtonFlowPanel();
        this.btnContentPanel.add((Component)buttonFlowPanel, "East");
        JButton closeBtn = new JButton(new DisposeDialogAction(this, "Schlie\u00dfen", "Dialog schlie\u00dfen"));
        buttonFlowPanel.add(closeBtn);
        this.getRootPane().setDefaultButton(closeBtn);
        JButton btn = new JButton("Filmliste laden");
        btn.addActionListener(arg_0 -> LoadFilmListDialog.createButtonPanel$lambda$0(this, arg_0));
        buttonFlowPanel.add(btn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void restoreWindowSizeFromConfig() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            int width = config.getInt("dialog.load_filmlist.width");
            int height = config.getInt("dialog.load_filmlist.height");
            int x = config.getInt("dialog.load_filmlist.x");
            int y = config.getInt("dialog.load_filmlist.y");
            this.setBounds(x, y, width, height);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.pack();
            if (this.getWidth() < 100 || this.getHeight() < 100) {
                this.setSize(640, 480);
            }
            GuiFunktionen.centerOnScreen(this, false);
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    private final void registerWindowSizeListener() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.storeWindowPosition(e);
            }

            public void componentMoved(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.storeWindowPosition(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void storeWindowPosition(ComponentEvent e) {
                Configuration config = ApplicationConfiguration.getConfiguration();
                Component component = e.getComponent();
                Dimension dims = component.getSize();
                Point loc = component.getLocation();
                try {
                    config.lock(LockMode.WRITE);
                    config.setProperty("dialog.load_filmlist.width", (Object)dims.width);
                    config.setProperty("dialog.load_filmlist.height", (Object)dims.height);
                    config.setProperty("dialog.load_filmlist.x", (Object)loc.x);
                    config.setProperty("dialog.load_filmlist.y", (Object)loc.y);
                }
                finally {
                    config.unlock(LockMode.WRITE);
                }
            }
        });
    }

    private static final void createButtonPanel$lambda$0(LoadFilmListDialog this$0, ActionEvent it) {
        FilmeLaden filmeLaden = Daten.getInstance().getFilmeLaden();
        boolean immerNeuLaden = this$0.contentPanel.hasSenderSelectionChanged();
        if (immerNeuLaden && !this$0.contentPanel.getJCheckBoxUpdate().isSelected()) {
            this$0.logger.trace("Sender list was changed loading full list...");
        }
        if (GuiFunktionen.getFilmListUpdateType() == FilmListUpdateType.AUTOMATIC) {
            filmeLaden.loadFilmlist("", immerNeuLaden);
        } else {
            String strUrl = this$0.contentPanel.getJTextFieldUrl().getText();
            Intrinsics.checkNotNull((Object)strUrl);
            if (StringsKt.contains((CharSequence)strUrl, (CharSequence)"mediathekview.de", (boolean)true)) {
                JOptionPane.showMessageDialog(this$0, "Bitte vermeiden Sie das Laden der Filmliste von unseren Servern \u00fcber eine manuell eingegebene URL.\n\nSie umgehen damit unter Umst\u00e4nden Mechanismen, die eine Lastverteilung auf unseren Servern erm\u00f6glichen\noder erhalten veraltete Dateien.\n\nNutzen Sie diese M\u00f6glichkeit NUR, wenn der regul\u00e4re Download OHNE manuelle Adresse nicht funktioniert.\nSie k\u00f6nnen sicher sein, dass wir einen Fehler schnellstm\u00f6glich beheben werden.", "MediathekView", 2);
            }
            if (this$0.contentPanel.getJCheckBoxUpdate().isSelected()) {
                filmeLaden.updateFilmlist(strUrl);
            } else {
                filmeLaden.loadFilmlist(strUrl, immerNeuLaden);
            }
        }
        this$0.dispose();
    }

    private static final void _init_$lambda$0(LoadFilmListDialog this$0) {
        this$0.dispose();
    }
}

