/*
 * Decompiled with CFR 0.152.
 */
package mediathek.swing;

import com.formdev.flatlaf.FlatLaf;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.swing.FontIcon;

public class IconUtils {
    public static final int DEFAULT_SIZE = 16;
    public static final int DEFAULT_TOOLBAR_SIZE = 18;
    public static final Color DEFAULT_LIGHT_COLOR = new Color(110, 110, 110);
    public static final Color DEFAULT_DARK_COLOR = new Color(176, 177, 179);
    protected static final int DEFAULT_MAC_TOOLBAR_WINDOWBAR_SIZE = 16;
    protected static final int DEFAULT_WINDOWS_TOOLBAR_WINDOWBAR_SIZE = 18;
    private static final List<WeakReference<FontIcon>> themedIcons = new ArrayList<WeakReference<FontIcon>>();

    public static FontIcon of(Ikon ikon) {
        return IconUtils.of(ikon, 16);
    }

    protected static int windowBarSpecificSize() {
        int size = SystemUtils.IS_OS_MAC_OSX ? 16 : (SystemUtils.IS_OS_WINDOWS ? 18 : 18);
        return size;
    }

    public static ImageIcon generateDisabledIcon(@NotNull Action action) {
        FontIcon normalIcon = (FontIcon)action.getValue("SmallIcon");
        if (normalIcon != null) {
            return IconUtils.generateDisabledIcon((Icon)normalIcon);
        }
        return null;
    }

    public static ImageIcon generateDisabledIcon(@NotNull Icon normalIcon) {
        BufferedImage img = new BufferedImage(normalIcon.getIconWidth(), normalIcon.getIconHeight(), 2);
        Graphics2D g2 = img.createGraphics();
        try {
            normalIcon.paintIcon(null, g2, 0, 0);
        }
        finally {
            g2.dispose();
        }
        Image disabledImg = GrayFilter.createDisabledImage(img);
        return new ImageIcon(disabledImg);
    }

    public static FontIcon windowBarSpecificToolbarIcon(Ikon ikon) {
        return IconUtils.of(ikon, IconUtils.windowBarSpecificSize());
    }

    public static FontIcon toolbarIcon(Ikon ikon) {
        return IconUtils.of(ikon, 18);
    }

    public static FontIcon windowBarSpecificToolbarIcon(Ikon ikon, Color color) {
        return FontIcon.of((Ikon)ikon, (int)IconUtils.windowBarSpecificSize(), (Color)color);
    }

    private static Color defaultColor() {
        return FlatLaf.isLafDark() ? DEFAULT_DARK_COLOR : DEFAULT_LIGHT_COLOR;
    }

    public static FontIcon of(Ikon ikon, int size) {
        return IconUtils.of(ikon, size, IconUtils.defaultColor());
    }

    protected static FontIcon of(Ikon ikon, int size, Color color) {
        FontIcon icon = FontIcon.of((Ikon)ikon, (int)size, (Color)color);
        themedIcons.add(new WeakReference<FontIcon>(icon));
        return icon;
    }

    private static void updateIconColors() {
        if (themedIcons.isEmpty()) {
            return;
        }
        Iterator<WeakReference<FontIcon>> iter = themedIcons.iterator();
        while (iter.hasNext()) {
            FontIcon icon = (FontIcon)iter.next().get();
            if (icon == null) {
                System.out.println("REMOVED REFERENCE TO WEAK ICON");
                iter.remove();
                continue;
            }
            icon.setIconColor(IconUtils.defaultColor());
        }
    }

    static {
        PropertyChangeListener lafListener = evt -> {
            if ("lookAndFeel".equals(evt.getPropertyName())) {
                IconUtils.updateIconColors();
            }
        };
        UIManager.addPropertyChangeListener(lafListener);
    }
}

