<?php

declare(strict_types=1);

namespace OCA\Talk\Vendor\CuyZ\Valinor\Type\Parser\Lexer\Token;

use OCA\Talk\Vendor\CuyZ\Valinor\Type\Parser\Lexer\TokenStream;
use OCA\Talk\Vendor\CuyZ\Valinor\Type\Type;

/** @internal */
final class TypeToken implements TraversingToken
{
    private Type $type;

    private string $symbol;

    public function __construct(Type $type)
    {
        $this->type = $type;
        $this->symbol = $type->toString();
    }

    public static function withSymbol(Type $type, string $symbol): self
    {
        $self = new self($type);
        $self->symbol = $symbol;

        return $self;
    }

    public function traverse(TokenStream $stream): Type
    {
        return $this->type;
    }

    public function symbol(): string
    {
        return $this->symbol;
    }
}
