/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import org.opensearch.common.cache.ICacheKey;
import org.opensearch.common.cache.RemovalNotification;
import org.opensearch.common.cache.RemovalReason;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.index.cache.request.ShardRequestCache;
import org.opensearch.indices.IndicesRequestCache;

abstract class AbstractIndexShardCacheEntity
implements IndicesRequestCache.CacheEntity {
    AbstractIndexShardCacheEntity() {
    }

    protected abstract ShardRequestCache stats();

    @Override
    public final void onCached(ICacheKey<IndicesRequestCache.Key> key, BytesReference value) {
        this.stats().onCached(this.getRamBytesUsedInKey(key), value);
    }

    @Override
    public final void onHit() {
        this.stats().onHit();
    }

    @Override
    public final void onMiss() {
        this.stats().onMiss();
    }

    @Override
    public final void onRemoval(RemovalNotification<ICacheKey<IndicesRequestCache.Key>, BytesReference> notification) {
        this.stats().onRemoval(this.getRamBytesUsedInKey(notification.getKey()), notification.getValue(), notification.getRemovalReason() == RemovalReason.EVICTED);
    }

    private long getRamBytesUsedInKey(ICacheKey<IndicesRequestCache.Key> key) {
        long innerKeyRamBytesUsed = 0L;
        if (key.key != null) {
            innerKeyRamBytesUsed = ((IndicesRequestCache.Key)key.key).ramBytesUsed();
        }
        return key.ramBytesUsed(innerKeyRamBytesUsed);
    }
}

