/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.utils;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ComparableLinkedHashMap<K, V>
extends LinkedHashMap<K, V>
implements Comparable<ComparableLinkedHashMap<K, V>> {
    public ComparableLinkedHashMap() {
    }

    public ComparableLinkedHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ComparableLinkedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    public int compareTo(ComparableLinkedHashMap<K, V> other) {
        if (this.isEmpty() && other.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (other.isEmpty()) {
            return 1;
        }
        Iterator thisIterator = this.entrySet().iterator();
        Iterator otherIterator = other.entrySet().iterator();
        return this.compareRecursive(thisIterator, otherIterator);
    }

    private int compareRecursive(Iterator<Map.Entry<K, V>> thisIterator, Iterator<Map.Entry<K, V>> otherIterator) {
        V otherValue;
        V thisValue;
        K otherKey;
        boolean thisHasNext = thisIterator.hasNext();
        boolean otherHasNext = otherIterator.hasNext();
        if (!thisHasNext && !otherHasNext) {
            return 0;
        }
        if (!thisHasNext) {
            return -1;
        }
        if (!otherHasNext) {
            return 1;
        }
        Map.Entry<K, V> thisEntry = thisIterator.next();
        Map.Entry<K, V> otherEntry = otherIterator.next();
        K thisKey = thisEntry.getKey();
        int comparison = this.compareKV(thisKey, otherKey = otherEntry.getKey(), thisValue = thisEntry.getValue(), otherValue = otherEntry.getValue());
        if (comparison != 0) {
            return comparison;
        }
        return this.compareRecursive(thisIterator, otherIterator);
    }

    private int compareKV(K key1, K key2, V value1, V value2) {
        int keyCompare = key1 instanceof Comparable ? ((Comparable)key1).compareTo(key2) : key1.toString().compareTo(key2.toString());
        if (keyCompare != 0) {
            return keyCompare;
        }
        if (value1 == null && value2 == null) {
            return 0;
        }
        if (value1 == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        if (value1 instanceof Comparable) {
            return ((Comparable)value1).compareTo(value2);
        }
        return value1.toString().compareTo(value2.toString());
    }
}

