/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.SketchesStateException;
import com.yahoo.sketches.hll.AbstractCoupons;
import com.yahoo.sketches.hll.CouponHashSet;
import com.yahoo.sketches.hll.CurMode;
import com.yahoo.sketches.hll.HllArray;
import com.yahoo.sketches.hll.HllSketchImpl;
import com.yahoo.sketches.hll.IntArrayPairIterator;
import com.yahoo.sketches.hll.PairIterator;
import com.yahoo.sketches.hll.PreambleUtil;
import com.yahoo.sketches.hll.TgtHllType;

class CouponList
extends AbstractCoupons {
    boolean oooFlag = false;
    int lgCouponArrInts;
    int couponCount;
    int[] couponIntArr;

    CouponList(int lgConfigK, TgtHllType tgtHllType, CurMode curMode) {
        super(lgConfigK, tgtHllType, curMode);
        if (curMode == CurMode.LIST) {
            this.lgCouponArrInts = 3;
            this.oooFlag = false;
        } else {
            this.lgCouponArrInts = 5;
            assert (lgConfigK > 7);
            this.oooFlag = true;
        }
        this.couponIntArr = new int[1 << this.lgCouponArrInts];
        this.couponCount = 0;
    }

    CouponList(CouponList that) {
        super(that.lgConfigK, that.tgtHllType, that.curMode);
        this.oooFlag = that.oooFlag;
        this.lgCouponArrInts = that.lgCouponArrInts;
        this.couponCount = that.couponCount;
        this.couponIntArr = (int[])that.couponIntArr.clone();
    }

    CouponList(CouponList that, TgtHllType tgtHllType) {
        super(that.lgConfigK, tgtHllType, that.curMode);
        this.oooFlag = that.oooFlag;
        this.lgCouponArrInts = that.lgCouponArrInts;
        this.couponCount = that.couponCount;
        this.couponIntArr = (int[])that.couponIntArr.clone();
    }

    static final CouponList heapifyList(Memory mem) {
        int lgConfigK = PreambleUtil.extractLgK(mem);
        TgtHllType tgtHllType = PreambleUtil.extractTgtHllType(mem);
        CouponList list = new CouponList(lgConfigK, tgtHllType, CurMode.LIST);
        int couponCount = PreambleUtil.extractListCount(mem);
        mem.getIntArray((long)PreambleUtil.LIST_INT_ARR_START, list.couponIntArr, 0, couponCount);
        list.couponCount = couponCount;
        list.putOutOfOrderFlag(PreambleUtil.extractOooFlag(mem));
        return list;
    }

    @Override
    CouponList copy() {
        return new CouponList(this);
    }

    @Override
    CouponList copyAs(TgtHllType tgtHllType) {
        return new CouponList(this, tgtHllType);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        int len = 1 << this.lgCouponArrInts;
        for (int i = 0; i < len; ++i) {
            int couponAtIdx = this.couponIntArr[i];
            if (couponAtIdx == 0) {
                this.couponIntArr[i] = coupon;
                ++this.couponCount;
                if (this.couponCount >= len) {
                    if (this.lgConfigK < 8) {
                        return CouponList.promoteHeapListOrSetToHll(this);
                    }
                    return CouponList.promoteHeapListToSet(this);
                }
                return this;
            }
            if (couponAtIdx != coupon) continue;
            return this;
        }
        throw new SketchesStateException("Array invalid: no empties & no duplicates");
    }

    @Override
    int getCompactSerializationBytes() {
        return this.getMemDataStart() + (this.couponCount << 2);
    }

    @Override
    int getCouponCount() {
        return this.couponCount;
    }

    @Override
    int[] getCouponIntArr() {
        return this.couponIntArr;
    }

    @Override
    PairIterator iterator() {
        return new IntArrayPairIterator(this.couponIntArr, this.lgConfigK);
    }

    @Override
    int getLgCouponArrInts() {
        return this.lgCouponArrInts;
    }

    @Override
    int getMemDataStart() {
        return PreambleUtil.LIST_INT_ARR_START;
    }

    @Override
    Memory getMemory() {
        return null;
    }

    @Override
    int getPreInts() {
        return 2;
    }

    @Override
    WritableMemory getWritableMemory() {
        return null;
    }

    @Override
    boolean isCompact() {
        return false;
    }

    @Override
    boolean isMemory() {
        return false;
    }

    @Override
    boolean isOffHeap() {
        return false;
    }

    @Override
    boolean isOutOfOrderFlag() {
        return this.oooFlag;
    }

    @Override
    boolean isSameResource(Memory mem) {
        return false;
    }

    @Override
    void putOutOfOrderFlag(boolean oooFlag) {
        this.oooFlag = oooFlag;
    }

    @Override
    CouponList reset() {
        return new CouponList(this.lgConfigK, this.tgtHllType, CurMode.LIST);
    }

    static final HllSketchImpl promoteHeapListToSet(CouponList list) {
        int couponCount = list.couponCount;
        int[] arr = list.couponIntArr;
        CouponHashSet chSet = new CouponHashSet(list.lgConfigK, list.tgtHllType);
        for (int i = 0; i < couponCount; ++i) {
            chSet.couponUpdate(arr[i]);
        }
        chSet.putOutOfOrderFlag(true);
        return chSet;
    }

    static final HllSketchImpl promoteHeapListOrSetToHll(CouponList src) {
        HllArray tgtHllArr = HllArray.newHeapHll(src.lgConfigK, src.tgtHllType);
        PairIterator srcItr = src.iterator();
        tgtHllArr.putKxQ0(1 << src.lgConfigK);
        while (srcItr.nextValid()) {
            tgtHllArr.couponUpdate(srcItr.getPair());
        }
        tgtHllArr.putHipAccum(src.getEstimate());
        tgtHllArr.putOutOfOrderFlag(false);
        return tgtHllArr;
    }
}

