"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDatePopoverButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _popover = require("../../../popover");
var _pretty_duration = require("../pretty_duration");
var _date_popover_content = require("./date_popover_content");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// eslint-disable-line import/named

var EuiDatePopoverButton = function EuiDatePopoverButton(props) {
  var position = props.position,
    isDisabled = props.isDisabled,
    isInvalid = props.isInvalid,
    needsUpdating = props.needsUpdating,
    value = props.value,
    buttonProps = props.buttonProps,
    roundUp = props.roundUp,
    onChange = props.onChange,
    locale = props.locale,
    dateFormat = props.dateFormat,
    utcOffset = props.utcOffset,
    timeFormat = props.timeFormat,
    isOpen = props.isOpen,
    onPopoverToggle = props.onPopoverToggle,
    onPopoverClose = props.onPopoverClose,
    compressed = props.compressed,
    rest = _objectWithoutProperties(props, ["position", "isDisabled", "isInvalid", "needsUpdating", "value", "buttonProps", "roundUp", "onChange", "locale", "dateFormat", "utcOffset", "timeFormat", "isOpen", "onPopoverToggle", "onPopoverClose", "compressed"]);
  var classes = (0, _classnames.default)(['euiDatePopoverButton', "euiDatePopoverButton--".concat(position), {
    'euiDatePopoverButton-isSelected': isOpen,
    'euiDatePopoverButton-isInvalid': isInvalid,
    'euiDatePopoverButton-needsUpdating': needsUpdating,
    'euiDatePopoverButton-disabled': isDisabled,
    'euiDatePopoverButton-compressed': compressed
  }]);
  var title = value;
  if (isInvalid) {
    title = "Invalid date: ".concat(title);
  } else if (needsUpdating) {
    title = "Update needed: ".concat(title);
  }
  var button = /*#__PURE__*/_react.default.createElement("button", _extends({
    onClick: onPopoverToggle,
    className: classes,
    title: title,
    disabled: isDisabled,
    "data-test-subj": "superDatePicker".concat(position, "DatePopoverButton")
  }, buttonProps), (0, _pretty_duration.formatTimeString)(value, dateFormat, roundUp, locale));
  return /*#__PURE__*/_react.default.createElement(_popover.EuiPopover, _extends({
    button: button,
    isOpen: isOpen,
    closePopover: onPopoverClose,
    anchorPosition: position === 'start' ? 'downLeft' : 'downRight',
    display: "block",
    panelPaddingSize: "none"
  }, rest), /*#__PURE__*/_react.default.createElement(_date_popover_content.EuiDatePopoverContent, {
    value: value,
    roundUp: roundUp,
    onChange: onChange,
    dateFormat: dateFormat,
    timeFormat: timeFormat,
    locale: locale,
    position: position,
    utcOffset: utcOffset
  }));
};
exports.EuiDatePopoverButton = EuiDatePopoverButton;
EuiDatePopoverButton.propTypes = {
  className: _propTypes.default.string,
  buttonProps: _propTypes.default.any,
  dateFormat: _propTypes.default.string.isRequired,
  isDisabled: _propTypes.default.bool,
  isInvalid: _propTypes.default.bool,
  isOpen: _propTypes.default.bool.isRequired,
  needsUpdating: _propTypes.default.bool,
  locale: _propTypes.default.any,
  onChange: _propTypes.default.any.isRequired,
  onPopoverClose: _propTypes.default.any.isRequired,
  onPopoverToggle: _propTypes.default.func.isRequired,
  position: _propTypes.default.oneOf(["start", "end"]).isRequired,
  roundUp: _propTypes.default.bool,
  timeFormat: _propTypes.default.string.isRequired,
  value: _propTypes.default.string.isRequired,
  utcOffset: _propTypes.default.number,
  compressed: _propTypes.default.bool
};
EuiDatePopoverButton.displayName = 'EuiDatePopoverButton';