// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import { needs } from '@aws-crypto/material-management';
const UINT8_OVERFLOW = 2 ** 8;
export function uInt8(number) {
    /* Precondition: Number must be 0-(2^8 - 1). */
    needs(number < UINT8_OVERFLOW && number >= 0, 'number out of bounds.');
    const buff = new Uint8Array(1);
    const view = new DataView(buff.buffer, buff.byteOffset, buff.byteLength);
    view.setUint8(0, number);
    return buff;
}
const UINT16__OVERFLOW = 2 ** 16;
export function uInt16BE(number) {
    /* Precondition: Number must be 0-(2^16 - 1). */
    needs(number < UINT16__OVERFLOW && number >= 0, 'number out of bounds.');
    const buff = new Uint8Array(2);
    const view = new DataView(buff.buffer, buff.byteOffset, buff.byteLength);
    view.setUint16(0, number, false); // big-endian
    return buff;
}
const UINT32__OVERFLOW = 2 ** 32;
export function uInt32BE(number) {
    /* Precondition: Number must be 0-(2^32 - 1). */
    needs(number < UINT32__OVERFLOW && number >= 0, 'number out of bounds.');
    const buff = new Uint8Array(4);
    const view = new DataView(buff.buffer, buff.byteOffset, buff.byteLength);
    view.setUint32(0, number, false); // big-endian
    return buff;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidWludF91dGlsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3VpbnRfdXRpbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxvRUFBb0U7QUFDcEUsc0NBQXNDO0FBRXRDLE9BQU8sRUFBRSxLQUFLLEVBQUUsTUFBTSxpQ0FBaUMsQ0FBQTtBQUV2RCxNQUFNLGNBQWMsR0FBRyxDQUFDLElBQUksQ0FBQyxDQUFBO0FBQzdCLE1BQU0sVUFBVSxLQUFLLENBQUMsTUFBYztJQUNsQywrQ0FBK0M7SUFDL0MsS0FBSyxDQUFDLE1BQU0sR0FBRyxjQUFjLElBQUksTUFBTSxJQUFJLENBQUMsRUFBRSx1QkFBdUIsQ0FBQyxDQUFBO0lBRXRFLE1BQU0sSUFBSSxHQUFHLElBQUksVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFBO0lBQzlCLE1BQU0sSUFBSSxHQUFHLElBQUksUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUE7SUFDeEUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDLEVBQUUsTUFBTSxDQUFDLENBQUE7SUFDeEIsT0FBTyxJQUFJLENBQUE7QUFDYixDQUFDO0FBRUQsTUFBTSxnQkFBZ0IsR0FBRyxDQUFDLElBQUksRUFBRSxDQUFBO0FBQ2hDLE1BQU0sVUFBVSxRQUFRLENBQUMsTUFBYztJQUNyQyxnREFBZ0Q7SUFDaEQsS0FBSyxDQUFDLE1BQU0sR0FBRyxnQkFBZ0IsSUFBSSxNQUFNLElBQUksQ0FBQyxFQUFFLHVCQUF1QixDQUFDLENBQUE7SUFFeEUsTUFBTSxJQUFJLEdBQUcsSUFBSSxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUE7SUFDOUIsTUFBTSxJQUFJLEdBQUcsSUFBSSxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQTtJQUN4RSxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUMsRUFBRSxNQUFNLEVBQUUsS0FBSyxDQUFDLENBQUEsQ0FBQyxhQUFhO0lBQzlDLE9BQU8sSUFBSSxDQUFBO0FBQ2IsQ0FBQztBQUVELE1BQU0sZ0JBQWdCLEdBQUcsQ0FBQyxJQUFJLEVBQUUsQ0FBQTtBQUNoQyxNQUFNLFVBQVUsUUFBUSxDQUFDLE1BQWM7SUFDckMsZ0RBQWdEO0lBQ2hELEtBQUssQ0FBQyxNQUFNLEdBQUcsZ0JBQWdCLElBQUksTUFBTSxJQUFJLENBQUMsRUFBRSx1QkFBdUIsQ0FBQyxDQUFBO0lBRXhFLE1BQU0sSUFBSSxHQUFHLElBQUksVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFBO0lBQzlCLE1BQU0sSUFBSSxHQUFHLElBQUksUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUE7SUFDeEUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLEVBQUUsTUFBTSxFQUFFLEtBQUssQ0FBQyxDQUFBLENBQUMsYUFBYTtJQUM5QyxPQUFPLElBQUksQ0FBQTtBQUNiLENBQUMifQ==