"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrometheusConnectionClient = void 0;
var _base_connection_client = require("./base_connection_client");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class PrometheusConnectionClient extends _base_connection_client.BaseConnectionClient {
  constructor(context, _request) {
    super();
    // Prometheus connections are always created with "Local Cluster". Always use the non-MDS client.
    _defineProperty(this, "client", void 0);
    this.client = context.core.opensearch.client.asCurrentUser;
  }
  async getResources(request) {
    const response = await this.client.transport.request({
      ...request,
      method: 'GET'
    });
    return {
      status: response.body.status,
      data: response.body.data,
      type: 'prometheus'
    };
  }
}
exports.PrometheusConnectionClient = PrometheusConnectionClient;