/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.exactsearch;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.opensearch.common.Nullable;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.query.SegmentLevelQuantizationInfo;
import org.opensearch.knn.index.query.exactsearch.VectorIdsExactKNNIterator;
import org.opensearch.knn.index.vectorvalues.KNNFloatVectorValues;

class NestedVectorIdsExactKNNIterator
extends VectorIdsExactKNNIterator {
    private final BitSet parentBitSet;

    public NestedVectorIdsExactKNNIterator(@Nullable DocIdSetIterator filterIdsIterator, float[] queryVector, KNNFloatVectorValues knnFloatVectorValues, SpaceType spaceType, BitSet parentBitSet) throws IOException {
        this(filterIdsIterator, queryVector, knnFloatVectorValues, spaceType, parentBitSet, null, null);
    }

    public NestedVectorIdsExactKNNIterator(float[] queryVector, KNNFloatVectorValues knnFloatVectorValues, SpaceType spaceType, BitSet parentBitSet) throws IOException {
        this(null, queryVector, knnFloatVectorValues, spaceType, parentBitSet, null, null);
    }

    public NestedVectorIdsExactKNNIterator(@Nullable DocIdSetIterator filterIdsIterator, float[] queryVector, KNNFloatVectorValues knnFloatVectorValues, SpaceType spaceType, BitSet parentBitSet, byte[] quantizedVector, SegmentLevelQuantizationInfo segmentLevelQuantizationInfo) throws IOException {
        super(filterIdsIterator, queryVector, knnFloatVectorValues, spaceType, quantizedVector, segmentLevelQuantizationInfo);
        this.parentBitSet = parentBitSet;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.docId == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        this.currentScore = Float.NEGATIVE_INFINITY;
        int currentParent = this.parentBitSet.nextSetBit(this.docId);
        int bestChild = -1;
        while (this.docId != Integer.MAX_VALUE && this.docId < currentParent) {
            float score = this.computeScore();
            if (score > this.currentScore) {
                bestChild = this.docId;
                this.currentScore = score;
            }
            this.docId = this.getNextDocId();
        }
        return bestChild;
    }
}

