/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.netty4;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.settings.Settings;
import org.opensearch.http.HttpRequest;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.http.HttpTransportSettings;
import org.opensearch.http.netty4.HttpResponseHeadersFactory;
import org.opensearch.http.netty4.http3.Http3Utils;

public final class HttpResponseHeadersFactories {
    private static final String ALT_SVC_HEADER = "Alt-Svc";

    public static HttpResponseHeadersFactory newHttp2Aware(Settings settings, HttpServerTransport transport) {
        return new Http2AwareResponseHeadersFactory(transport);
    }

    public static HttpResponseHeadersFactory newHttp3Aware(Settings settings, HttpServerTransport transport) {
        if (Http3Utils.isHttp3Available() && ((Boolean)HttpTransportSettings.SETTING_HTTP_HTTP3_ENABLED.get(settings)).booleanValue()) {
            return new Http3AwareResponseHeadersFactory(transport);
        }
        return HttpResponseHeadersFactories.newDefault();
    }

    public static HttpResponseHeadersFactory newDefault() {
        return new HttpResponseHeadersFactory(){

            @Override
            public Map<String, String> headers(HttpRequest.HttpVersion version) {
                return Map.of();
            }
        };
    }

    private static class Http2AwareResponseHeadersFactory
    implements HttpResponseHeadersFactory {
        private final HttpServerTransport transport;

        public Http2AwareResponseHeadersFactory(HttpServerTransport transport) {
            this.transport = Objects.requireNonNull(transport);
        }

        @Override
        public Map<String, String> headers(HttpRequest.HttpVersion version) {
            return Map.of(HttpResponseHeadersFactories.ALT_SVC_HEADER, String.join((CharSequence)", ", Arrays.stream(this.transport.boundAddress().boundAddresses()).map(address -> String.format(Locale.ENGLISH, "h2=\":%d\"; ma=3600", address.getPort())).distinct().toList()));
        }
    }

    private static class Http3AwareResponseHeadersFactory
    implements HttpResponseHeadersFactory {
        private final HttpServerTransport transport;

        public Http3AwareResponseHeadersFactory(HttpServerTransport transport) {
            this.transport = Objects.requireNonNull(transport);
        }

        @Override
        public Map<String, String> headers(HttpRequest.HttpVersion version) {
            return Map.of(HttpResponseHeadersFactories.ALT_SVC_HEADER, String.join((CharSequence)", ", Arrays.stream(this.transport.boundAddress().boundAddresses()).map(address -> String.format(Locale.ENGLISH, "h3=\":%d\"; ma=3600", address.getPort())).distinct().toList()));
        }
    }
}

