/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class ExpressionStatement
extends Statement {
    public ExpressionStatement(Expression expression) {
        super(expression.getOffset());
        this.setExpression(expression);
    }

    @Override
    public boolean isEmbeddable() {
        return true;
    }

    public final Expression getExpression() {
        return this.getChildByRole(Roles.EXPRESSION);
    }

    public final void setExpression(Expression value) {
        this.setChildByRole(Roles.EXPRESSION, value);
    }

    public final JavaTokenNode getSemicolonToken() {
        return this.getChildByRole(Roles.SEMICOLON);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitExpressionStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof ExpressionStatement && !other.isNull() && this.getExpression().matches(((ExpressionStatement)other).getExpression(), match);
    }
}

