/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.conflict;

import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.branch.GitRebaseParams;
import git4idea.i18n.GitBundleExtensions;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt;
import git4idea.merge.GitMergeDialogCustomizerHelper;
import git4idea.merge.GitMergeProvider;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0010\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u001a\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u001d\u0010\u0019\u001a\u0017\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u001d0\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0015\u001a\u00020 H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0015\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lgit4idea/rebase/conflict/GitRebaseMergeDialogCustomizer;", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;", "repository", "Lgit4idea/repo/GitRepository;", "upstream", "Lgit4idea/branch/GitRebaseParams$RebaseUpstream;", "rebasingBranch", "", "ingoingCommit", "Lcom/intellij/vcs/log/Hash;", "mergeBase", "<init>", "(Lgit4idea/repo/GitRepository;Lgit4idea/branch/GitRebaseParams$RebaseUpstream;Ljava/lang/String;Lcom/intellij/vcs/log/Hash;Lcom/intellij/vcs/log/Hash;)V", "baseHash", "basePresentable", "baseBranch", "getMultipleFileMergeDescription", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLeftPanelTitle", "file", "getRightPanelTitle", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "getColumnNames", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsContexts$ColumnName;", "Lkotlin/jvm/internal/EnhancedNullability;", "getTitleCustomizerList", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "Lcom/intellij/openapi/vcs/FilePath;", "getLeftTitleCustomizer", "Lcom/intellij/diff/DiffEditorTitleCustomizer;", "getRightTitleCustomizer", "intellij.vcs.git"})
final class GitRebaseMergeDialogCustomizer
extends MergeDialogCustomizer {
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final String rebasingBranch;
    @Nullable
    private final Hash ingoingCommit;
    @Nullable
    private final Hash mergeBase;
    @Nullable
    private final Hash baseHash;
    @NlsSafe
    @Nullable
    private final String basePresentable;
    @NlsSafe
    @Nullable
    private final String baseBranch;

    public GitRebaseMergeDialogCustomizer(@NotNull GitRepository repository2, @NotNull GitRebaseParams.RebaseUpstream upstream, @NlsSafe @NotNull String rebasingBranch, @Nullable Hash ingoingCommit, @Nullable Hash mergeBase) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)upstream, (String)"upstream");
        Intrinsics.checkNotNullParameter((Object)rebasingBranch, (String)"rebasingBranch");
        this.repository = repository2;
        this.rebasingBranch = rebasingBranch;
        this.ingoingCommit = ingoingCommit;
        this.mergeBase = mergeBase;
        if (upstream instanceof GitRebaseParams.RebaseUpstream.Commit) {
            this.basePresentable = ((GitRebaseParams.RebaseUpstream.Commit)upstream).getCommit().toShortString();
            this.baseBranch = null;
            this.baseHash = ((GitRebaseParams.RebaseUpstream.Commit)upstream).getCommit();
        } else if (upstream instanceof GitRebaseParams.RebaseUpstream.Reference) {
            this.basePresentable = ((GitRebaseParams.RebaseUpstream.Reference)upstream).getRef();
            this.baseBranch = ((GitRebaseParams.RebaseUpstream.Reference)upstream).getRef();
            this.baseHash = null;
        } else {
            this.basePresentable = null;
            this.baseBranch = null;
            this.baseHash = null;
        }
    }

    @NotNull
    public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return GitDefaultMergeDialogCustomizerKt.getDescriptionForRebase(this.repository, this.rebasingBranch, this.baseBranch, this.baseHash);
    }

    @NotNull
    public String getLeftPanelTitle(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return GitDefaultMergeDialogCustomizerKt.getDefaultLeftPanelTitleForBranch(this.rebasingBranch);
    }

    @NotNull
    public String getRightPanelTitle(@NotNull VirtualFile file, @Nullable VcsRevisionNumber revisionNumber) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VcsRevisionNumber vcsRevisionNumber = revisionNumber;
        Hash hash = vcsRevisionNumber != null ? HashImpl.build((String)vcsRevisionNumber.asString()) : this.baseHash;
        return GitDefaultMergeDialogCustomizerKt.getDefaultRightPanelTitleForBranch(this.baseBranch, hash);
    }

    @NotNull
    public List<String> getColumnNames() {
        Object[] objectArray = new String[]{GitMergeProvider.calcColumnName(false, this.rebasingBranch), GitMergeProvider.calcColumnName(true, this.basePresentable)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public MergeDialogCustomizer.DiffEditorTitleCustomizerList getTitleCustomizerList(@NotNull FilePath file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return GitMergeDialogCustomizerHelper.INSTANCE.getCustomizers(this.repository.getProject(), file, this.getLeftTitleCustomizer(file), this.getRightTitleCustomizer(file));
    }

    private final DiffEditorTitleCustomizer getLeftTitleCustomizer(FilePath file) {
        if (this.ingoingCommit == null) {
            return null;
        }
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.ingoingCommit.toShortString(), (String)"toShortString(...)");
        Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)this.rebasingBranch).bold(), (String)"bold(...)");
        String string = GitBundleExtensions.html("rebase.conflict.diff.dialog.left.title", objectArray);
        String string2 = this.ingoingCommit.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        return GitDefaultMergeDialogCustomizerKt.getTitleWithCommitDetailsCustomizer(string, this.repository, file, string2);
    }

    private final DiffEditorTitleCustomizer getRightTitleCustomizer(FilePath file) {
        String string;
        if (this.mergeBase == null) {
            return null;
        }
        if (this.baseBranch != null) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)this.baseBranch).bold(), (String)"bold(...)");
            string = GitBundleExtensions.html("rebase.conflict.diff.dialog.right.with.branch.title", objectArray);
        } else {
            string = GitBundleExtensions.html("rebase.conflict.diff.dialog.right.simple.title", new Object[0]);
        }
        String title = string;
        return GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer(title, this.repository, file, (Pair<String, String>)new Pair((Object)this.mergeBase.asString(), (Object)"HEAD"));
    }
}

