/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.assertj.swing.annotation.GUITest;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

public final class GUITestFinder {
    public static boolean isGUITest(@Nonnull Class<?> type, @Nonnull Method method) {
        return GUITestFinder.isGUITest(type) || GUITestFinder.isGUITest(method) || GUITestFinder.isSuperClassGUITest(type, method);
    }

    private static boolean isSuperClassGUITest(@Nonnull Class<?> type, @Nonnull Method method) {
        for (Class<?> superclass = type.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            if (GUITestFinder.isGUITest(superclass)) {
                return true;
            }
            Method overriden = GUITestFinder.findMethod(superclass, method);
            if (overriden == null || !GUITestFinder.isGUITest(overriden)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Method findMethod(@Nonnull Class<?> type, @Nonnull Method method) {
        try {
            return type.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static boolean isGUITest(@Nonnull AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(GUITest.class);
    }

    private GUITestFinder() {
    }
}

