/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pyproject.model.internal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemProjectLinkListener;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.pyproject.model.internal.PlatformToolsKt;
import com.intellij.python.pyproject.model.internal.PyExternalSystemUnlinkedProjectAwareKt;
import com.intellij.python.pyproject.model.internal.PyOpenProjectProvider;
import com.intellij.python.pyproject.model.internal.WorkspaceToolsKt;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0013J \u0010\u0015\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/python/pyproject/model/internal/PyExternalSystemUnlinkedProjectAware;", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemUnlinkedProjectAware;", "<init>", "()V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "isBuildFile", "", "project", "Lcom/intellij/openapi/project/Project;", "buildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isLinkedProject", "externalProjectPath", "", "unlinkProject", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "linkAndLoadProjectAsync", "subscribe", "listener", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemProjectLinkListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.python.pyproject"})
public final class PyExternalSystemUnlinkedProjectAware
implements ExternalSystemUnlinkedProjectAware {
    @NotNull
    private final ProjectSystemId systemId = PlatformToolsKt.getSYSTEM_ID();

    @NotNull
    public ProjectSystemId getSystemId() {
        return this.systemId;
    }

    public boolean isBuildFile(@NotNull Project project, @NotNull VirtualFile buildFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        return PyOpenProjectProvider.INSTANCE.canOpenProject(buildFile);
    }

    public boolean isLinkedProject(@NotNull Project project, @NotNull String externalProjectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        return WorkspaceToolsKt.isProjectLinked(project);
    }

    @Nullable
    public Object unlinkProject(@NotNull Project project, @NotNull String externalProjectPath, @NotNull Continuation<? super Unit> $completion) {
        Object object = PlatformToolsKt.unlinkProjectWithProgress(project, externalProjectPath, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object linkAndLoadProjectAsync(@NotNull Project project, @NotNull String externalProjectPath, @NotNull Continuation<? super Unit> $completion) {
        Path path;
        try {
            path = Path.of(externalProjectPath, new String[0]);
        }
        catch (IOException e) {
            PyExternalSystemUnlinkedProjectAwareKt.access$getLogger$p().warn("Provided path is wrong, probably workspace is broken: " + externalProjectPath, (Throwable)e);
            path = null;
        }
        Path path2 = path;
        PlatformToolsKt.linkProjectWithProgressInBackground(project, path2);
        return Unit.INSTANCE;
    }

    public void subscribe(@NotNull Project project, @NotNull ExternalSystemProjectLinkListener listener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        project.getMessageBus().connect(parentDisposable).subscribe(PlatformToolsKt.getPROJECT_LINKER_AWARE_TOPIC(), (Object)listener);
    }
}

