/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.ui;

import com.intellij.ide.startup.importSettings.TransferSettingsConfiguration;
import com.intellij.ide.startup.importSettings.controllers.TransferSettingsController;
import com.intellij.ide.startup.importSettings.controllers.TransferSettingsListener;
import com.intellij.ide.startup.importSettings.fus.TransferSettingsCollector;
import com.intellij.ide.startup.importSettings.models.BaseIdeVersion;
import com.intellij.ide.startup.importSettings.models.FailedIdeVersion;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.models.TransferSettingsModel;
import com.intellij.ide.startup.importSettings.transfer.backend.models.IdeVersion;
import com.intellij.ide.startup.importSettings.ui.TransferSettingsLeftPanel;
import com.intellij.ide.startup.importSettings.ui.representation.TransferSettingsRepresentationPanel;
import com.intellij.ide.startup.importSettings.ui.representation.TransferSettingsRightPanelChooser;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u000fH\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/startup/importSettings/ui/TransferSettingsView;", "", "config", "Lcom/intellij/ide/startup/importSettings/TransferSettingsConfiguration;", "model", "Lcom/intellij/ide/startup/importSettings/models/TransferSettingsModel;", "<init>", "(Lcom/intellij/ide/startup/importSettings/TransferSettingsConfiguration;Lcom/intellij/ide/startup/importSettings/models/TransferSettingsModel;)V", "selectedIde", "Lcom/intellij/ide/startup/importSettings/models/BaseIdeVersion;", "getSelectedIde", "()Lcom/intellij/ide/startup/importSettings/models/BaseIdeVersion;", "leftPanel", "Lcom/intellij/ide/startup/importSettings/ui/TransferSettingsLeftPanel;", "contentPanel", "Ljavax/swing/JPanel;", "cachedViews", "", "Lcom/intellij/ide/startup/importSettings/ui/representation/TransferSettingsRepresentationPanel;", "panel", "getPanel", "()Ljavax/swing/JPanel;", "initPanel", "performRefresh", "", "selectionTargetId", "", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nTransferSettingsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransferSettingsView.kt\ncom/intellij/ide/startup/importSettings/ui/TransferSettingsView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n360#2,7:100\n382#3,3:107\n385#3,4:111\n1#4:110\n*S KotlinDebug\n*F\n+ 1 TransferSettingsView.kt\ncom/intellij/ide/startup/importSettings/ui/TransferSettingsView\n*L\n96#1:100,7\n72#1:107,3\n72#1:111,4\n*E\n"})
public final class TransferSettingsView {
    @NotNull
    private final TransferSettingsConfiguration config;
    @NotNull
    private final TransferSettingsModel model;
    @NotNull
    private final TransferSettingsLeftPanel leftPanel;
    @NotNull
    private final JPanel contentPanel;
    @NotNull
    private final Map<BaseIdeVersion, TransferSettingsRepresentationPanel> cachedViews;
    @NotNull
    private final JPanel panel;

    public TransferSettingsView(@NotNull TransferSettingsConfiguration config, @NotNull TransferSettingsModel model) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.config = config;
        this.model = model;
        this.leftPanel = new TransferSettingsLeftPanel((ListModel<BaseIdeVersion>)this.model.getListModel());
        this.contentPanel = new JPanel((LayoutManager)new MigLayout("ins 0, novisualpadding, fill"));
        this.cachedViews = new LinkedHashMap();
        this.panel = this.initPanel();
        this.config.getController().addListener(new TransferSettingsListener(){

            @Override
            public void reloadPerformed(FailedIdeVersion ideVersion) {
                Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
                cachedViews.remove(ideVersion);
                this.performRefresh(ideVersion.getId());
            }

            @Override
            public void importStarted(IdeVersion ideVersion, Settings settings) {
                Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                TransferSettingsRepresentationPanel transferSettingsRepresentationPanel = (TransferSettingsRepresentationPanel)cachedViews.get(this.getSelectedIde());
                if (transferSettingsRepresentationPanel != null) {
                    transferSettingsRepresentationPanel.block();
                }
                leftPanel.getList().setEnabled(false);
            }
        });
    }

    @Nullable
    public final BaseIdeVersion getSelectedIde() {
        return this.leftPanel.getList().getSelectedValue();
    }

    @NotNull
    public final JPanel getPanel() {
        return this.panel;
    }

    private final JPanel initPanel() {
        JPanel jPanel;
        JPanel $this$initPanel_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$initPanel_u24lambda_u240.setLayout((LayoutManager)new MigLayout("ins 0, novisualpadding, fill"));
        $this$initPanel_u24lambda_u240.addComponentListener(new ComponentAdapter(){
            private boolean shown;

            public void componentShown(ComponentEvent e) {
                this.onEvent();
            }

            public void componentResized(ComponentEvent e) {
                this.onEvent();
            }

            private final void onEvent() {
                if (this.shown) {
                    return;
                }
                TransferSettingsCollector.INSTANCE.logTransferSettingsShown();
                this.shown = true;
            }
        });
        if (this.model.getShouldShowLeftPanel()) {
            $this$initPanel_u24lambda_u240.add((Component)((Object)this.leftPanel), "west, width 250px, wmax 250px, wmin 250px, growy, pushy, spany");
        }
        $this$initPanel_u24lambda_u240.add((Component)this.contentPanel, "east, grow, push, span");
        this.contentPanel.add(new JLabel());
        $this$initPanel_u24lambda_u240.setBorder(JBUI.Borders.customLineBottom((Color)JBColor.border()));
        Ref.ObjectRef previousSelected = new Ref.ObjectRef();
        this.leftPanel.addListSelectionListener((Function2<? super JList<BaseIdeVersion>, ? super ListSelectionEvent, Unit>)((Function2)(arg_0, arg_1) -> TransferSettingsView.initPanel$lambda$0$0(previousSelected, this, arg_0, arg_1)));
        this.performRefresh(null);
        return jPanel;
    }

    /*
     * WARNING - void declaration
     */
    private final void performRefresh(String selectionTargetId) {
        int n;
        List<BaseIdeVersion> newOrdered = this.model.performRefresh();
        JList<BaseIdeVersion> jList = this.leftPanel.getList();
        if (selectionTargetId != null) {
            int n2;
            JList<BaseIdeVersion> jList2;
            block4: {
                void $this$indexOfFirst$iv;
                List<BaseIdeVersion> list = newOrdered;
                jList2 = jList;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    BaseIdeVersion it = (BaseIdeVersion)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getId(), (Object)selectionTargetId)) {
                        n2 = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            int n3 = n2;
            jList = jList2;
            n = n3;
        } else {
            n = 0;
        }
        jList.setSelectedIndex(n);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit initPanel$lambda$0$0(Ref.ObjectRef $previousSelected, TransferSettingsView this$0, JList $this$addListSelectionListener, ListSelectionEvent it) {
        Object object;
        Object object2;
        block8: {
            Object value$iv;
            block5: {
                TransferSettingsRepresentationPanel transferSettingsRepresentationPanel;
                Object object3;
                void $this$getOrPut$iv;
                Object key$iv;
                block7: {
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)$this$addListSelectionListener, (String)"$this$addListSelectionListener");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if ($this$addListSelectionListener.getSelectedValue() == null) {
                            return Unit.INSTANCE;
                        }
                        if (Intrinsics.areEqual((Object)$previousSelected.element, $this$addListSelectionListener.getSelectedValue())) {
                            return Unit.INSTANCE;
                        }
                        $previousSelected.element = $this$addListSelectionListener.getSelectedValue();
                        object2 = this$0.cachedViews;
                        key$iv = $this$addListSelectionListener.getSelectedValue();
                        boolean $i$f$getOrPut = false;
                        value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv != null) break block5;
                        boolean bl = false;
                        Object e = $this$addListSelectionListener.getSelectedValue();
                        object3 = e instanceof IdeVersion ? (IdeVersion)e : null;
                        if (object3 == null) break block6;
                        IdeVersion it2 = object3;
                        boolean bl2 = false;
                        TransferSettingsRightPanelChooser transferSettingsRightPanelChooser = it2.getProvider().getRightPanel(it2, this$0.config);
                        object3 = transferSettingsRightPanelChooser;
                        if (transferSettingsRightPanelChooser != null) break block7;
                    }
                    Object e = $this$addListSelectionListener.getSelectedValue();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"getSelectedValue(...)");
                    object3 = new TransferSettingsRightPanelChooser((BaseIdeVersion)e, this$0.config);
                }
                Object chooser = object3;
                TransferSettingsRepresentationPanel $this$initPanel_u24lambda_u240_u240_u240_u241 = transferSettingsRepresentationPanel = ((TransferSettingsRightPanelChooser)chooser).select();
                boolean bl = false;
                $this$initPanel_u24lambda_u240_u240_u240_u241.onStateChange(() -> TransferSettingsView.initPanel$lambda$0$0$0$1$0($this$addListSelectionListener, this$0));
                TransferSettingsRepresentationPanel answer$iv = transferSettingsRepresentationPanel;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
                break block8;
            }
            object = value$iv;
        }
        TransferSettingsRepresentationPanel view = (TransferSettingsRepresentationPanel)object;
        Object $this$initPanel_u24lambda_u240_u240_u241 = object2 = this$0.contentPanel;
        boolean bl = false;
        ((Container)$this$initPanel_u24lambda_u240_u240_u241).removeAll();
        ((Container)$this$initPanel_u24lambda_u240_u240_u241).add((Component)view.getComponent(), "grow, push, span, wmax 100%");
        ((JComponent)$this$initPanel_u24lambda_u240_u240_u241).revalidate();
        ((Component)$this$initPanel_u24lambda_u240_u240_u241).repaint();
        TransferSettingsController transferSettingsController = this$0.config.getController();
        Object e = $this$addListSelectionListener.getSelectedValue();
        Intrinsics.checkNotNullExpressionValue(e, (String)"getSelectedValue(...)");
        transferSettingsController.itemSelected((BaseIdeVersion)e);
        return Unit.INSTANCE;
    }

    private static final void initPanel$lambda$0$0$0$1$0(JList $this_addListSelectionListener, TransferSettingsView this$0) {
        block0: {
            Object e = $this_addListSelectionListener.getSelectedValue();
            IdeVersion ideVersion = e instanceof IdeVersion ? (IdeVersion)e : null;
            if (ideVersion == null) break block0;
            IdeVersion it1 = ideVersion;
            boolean bl = false;
            this$0.config.getController().updateCheckboxes(it1);
        }
    }
}

