/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.ast.PyAstAnnotation;
import com.jetbrains.python.ast.PyAstAnnotationOwner;
import com.jetbrains.python.ast.PyAstCallExpression;
import com.jetbrains.python.ast.PyAstCallable;
import com.jetbrains.python.ast.PyAstClass;
import com.jetbrains.python.ast.PyAstCompoundStatement;
import com.jetbrains.python.ast.PyAstDecoratable;
import com.jetbrains.python.ast.PyAstDecoratorList;
import com.jetbrains.python.ast.PyAstDocStringOwner;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstParameterList;
import com.jetbrains.python.ast.PyAstPossibleClassMember;
import com.jetbrains.python.ast.PyAstRaiseStatement;
import com.jetbrains.python.ast.PyAstStatement;
import com.jetbrains.python.ast.PyAstStatementList;
import com.jetbrains.python.ast.PyAstStatementListContainer;
import com.jetbrains.python.ast.PyAstStringLiteralExpression;
import com.jetbrains.python.ast.PyAstTypeCommentOwner;
import com.jetbrains.python.ast.PyAstTypeParameterList;
import com.jetbrains.python.ast.PyAstTypeParameterListOwner;
import com.jetbrains.python.ast.controlFlow.AstScopeOwner;
import com.jetbrains.python.ast.docstring.DocStringUtilCore;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.psi.LanguageLevel;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstFunction
extends PsiNameIdentifierOwner,
PyAstCompoundStatement,
PyAstDecoratable,
PyAstCallable,
PyAstStatementListContainer,
PyAstPossibleClassMember,
AstScopeOwner,
PyAstDocStringOwner,
PyAstTypeCommentOwner,
PyAstAnnotationOwner,
PyAstTypeParameterListOwner {
    public static final PyAstFunction[] EMPTY_ARRAY;
    public static final ArrayFactory<PyAstFunction> ARRAY_FACTORY;

    @Nullable
    default public String getName() {
        ASTNode node = this.getNameNode();
        return node != null ? node.getText() : null;
    }

    @Nullable
    default public PsiElement getNameIdentifier() {
        ASTNode nameNode = this.getNameNode();
        return nameNode != null ? nameNode.getPsi() : null;
    }

    @Nullable
    default public ASTNode getNameNode() {
        ASTNode error;
        ASTNode id = this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
        if (id == null && (error = this.getNode().findChildByType(TokenType.ERROR_ELEMENT)) != null) {
            id = error.findChildByType(PythonDialectsTokenSetProvider.getInstance().getKeywordTokens());
        }
        return id;
    }

    @Override
    @NotNull
    default public PyAstStatementList getStatementList() {
        PyAstStatementList statementList = (PyAstStatementList)this.childToPsi(PyElementTypes.STATEMENT_LIST);
        if (!1.$assertionsDisabled && statementList == null) {
            throw new AssertionError((Object)("Statement list missing for function " + this.getText()));
        }
        PyAstStatementList pyAstStatementList = statementList;
        if (pyAstStatementList == null) {
            PyAstFunction.$$$reportNull$$$0(0);
        }
        return pyAstStatementList;
    }

    @Override
    @Nullable
    default public PyAstFunction asMethod() {
        if (this.getContainingClass() != null) {
            return this;
        }
        return null;
    }

    @Override
    @Nullable
    default public String getDocStringValue() {
        return DocStringUtilCore.getDocStringValue(this);
    }

    default public int getTextOffset() {
        ASTNode name = this.getNameNode();
        return name != null ? name.getStartOffset() : this.getNode().getStartOffset();
    }

    @Override
    @Nullable
    default public PyAstStringLiteralExpression getDocStringExpression() {
        PyAstStatementList stmtList = this.getStatementList();
        return DocStringUtilCore.findDocStringExpression(stmtList);
    }

    @Override
    @Nullable
    public PyAstTypeParameterList getTypeParameterList();

    @Nullable
    public Modifier getModifier();

    default public boolean isAsync() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.ASYNC_KEYWORD) != null;
    }

    default public boolean isAsyncAllowed() {
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)this);
        if (languageLevel.isOlderThan(LanguageLevel.PYTHON35)) {
            return false;
        }
        String functionName = this.getName();
        if (functionName == null || ArrayUtil.contains((String)functionName, (String[])new String[]{"__aiter__", "__anext__", "__aenter__", "__aexit__", "__call__"})) {
            return true;
        }
        Map builtinMethods = this.asMethod() != null ? PyNames.getBuiltinMethods((LanguageLevel)languageLevel) : PyNames.getModuleBuiltinMethods((LanguageLevel)languageLevel);
        return !builtinMethods.containsKey(functionName);
    }

    default public boolean onlyRaisesNotImplementedError() {
        PyAstStatement[] statements = this.getStatementList().getStatements();
        return statements.length == 1 && PyAstFunction.isRaiseNotImplementedError(statements[0]) || statements.length == 2 && PyUtilCore.isStringLiteral(statements[0]) && PyAstFunction.isRaiseNotImplementedError(statements[1]);
    }

    private static boolean isRaiseNotImplementedError(@NotNull PyAstStatement statement) {
        PyAstExpression callee;
        PyAstExpression raisedExpression;
        if (statement == null) {
            PyAstFunction.$$$reportNull$$$0(1);
        }
        return (raisedExpression = (PyAstExpression)Optional.ofNullable((PyAstRaiseStatement)ObjectUtils.tryCast((Object)statement, PyAstRaiseStatement.class)).map(PyAstRaiseStatement::getExpressions).filter(expressions -> ((PyAstExpression[])expressions).length == 1).map(expressions -> expressions[0]).orElse(null)) instanceof PyAstCallExpression ? (callee = ((PyAstCallExpression)raisedExpression).getCallee()) != null && callee.getText().equals("NotImplementedError") : raisedExpression != null && raisedExpression.getText().equals("NotImplementedError");
    }

    @NotNull
    default public ProtectionLevel getProtectionLevel() {
        int underscoreLevels = PyUtilCore.getInitialUnderscores(this.getName());
        for (ProtectionLevel level : ProtectionLevel.values()) {
            if (level.getUnderscoreLevel() != underscoreLevels) continue;
            ProtectionLevel protectionLevel = level;
            if (protectionLevel == null) {
                PyAstFunction.$$$reportNull$$$0(2);
            }
            return protectionLevel;
        }
        ProtectionLevel protectionLevel = ProtectionLevel.PRIVATE;
        if (protectionLevel == null) {
            PyAstFunction.$$$reportNull$$$0(3);
        }
        return protectionLevel;
    }

    @Override
    @Nullable
    public PyAstDecoratorList getDecoratorList();

    @Override
    public PyAstAnnotation getAnnotation();

    @Override
    @NotNull
    public PyAstParameterList getParameterList();

    @Override
    @Nullable
    default public PyAstClass getContainingClass() {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)this, StubBasedPsiElement.class);
        if (parent instanceof PyAstClass) {
            return (PyAstClass)parent;
        }
        return null;
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyFunction(this);
    }

    @Override
    @Nullable
    default public PsiComment getTypeComment() {
        PsiComment comment;
        PsiComment inlineComment = PyUtilCore.getCommentOnHeaderLine(this);
        if (inlineComment != null && PyUtilCore.getTypeCommentValue(inlineComment.getText()) != null) {
            return inlineComment;
        }
        PyAstStatementList statements = this.getStatementList();
        if (statements.getStatements().length != 0 && (comment = (PsiComment)ObjectUtils.tryCast((Object)statements.getFirstChild(), PsiComment.class)) != null && PyUtilCore.getTypeCommentValue(comment.getText()) != null) {
            return comment;
        }
        return null;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        EMPTY_ARRAY = new PyAstFunction[0];
        ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PyAstFunction[count];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/ast/PyAstFunction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/ast/PyAstFunction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtectionLevel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isRaiseNotImplementedError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static enum ProtectionLevel {
        PUBLIC(0),
        PROTECTED(1),
        PRIVATE(2);

        private final int myUnderscoreLevel;

        private ProtectionLevel(int underscoreLevel) {
            this.myUnderscoreLevel = underscoreLevel;
        }

        public int getUnderscoreLevel() {
            return this.myUnderscoreLevel;
        }
    }

    public static enum Modifier {
        CLASSMETHOD,
        STATICMETHOD;

    }
}

