/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.util.SmartFMap;
import com.intellij.util.xml.AnnotatedElement;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.JavaMethodSignature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class JavaMethod
implements AnnotatedElement {
    public static final JavaMethod[] EMPTY_ARRAY = new JavaMethod[0];
    private static final Object NONE = new Object();
    private final JavaMethodSignature mySignature;
    private final Class myDeclaringClass;
    private final Method myMethod;
    private volatile SmartFMap<Class, Object> myAnnotationsMap;
    private volatile List<Method> myHierarchy;

    private JavaMethod(@NotNull Class<?> declaringClass, JavaMethodSignature signature) {
        if (declaringClass == null) {
            JavaMethod.$$$reportNull$$$0(0);
        }
        this.myAnnotationsMap = SmartFMap.emptyMap();
        this.mySignature = signature;
        this.myMethod = signature.findMethod(declaringClass);
        assert (this.myMethod != null) : "No method " + String.valueOf(signature) + " in class " + String.valueOf(declaringClass);
        this.myDeclaringClass = this.myMethod.getDeclaringClass();
    }

    public Class<?> getDeclaringClass() {
        return this.myDeclaringClass;
    }

    public JavaMethodSignature getSignature() {
        return this.mySignature;
    }

    @NotNull
    public List<Method> getHierarchy() {
        List<Method> hierarchy = this.myHierarchy;
        if (hierarchy == null) {
            this.myHierarchy = hierarchy = Collections.unmodifiableList(this.mySignature.getAllMethods(this.myDeclaringClass));
        }
        List<Method> list = hierarchy;
        if (list == null) {
            JavaMethod.$$$reportNull$$$0(1);
        }
        return list;
    }

    public String getMethodName() {
        return this.mySignature.getMethodName();
    }

    public Method getMethod() {
        return this.myMethod;
    }

    public Type[] getGenericParameterTypes() {
        return this.myMethod.getGenericParameterTypes();
    }

    public Type getGenericReturnType() {
        return this.myMethod.getGenericReturnType();
    }

    public static JavaMethod getMethod(Class declaringClass, JavaMethodSignature signature) {
        return new JavaMethod(declaringClass, signature);
    }

    public static JavaMethod getMethod(Class declaringClass, Method method) {
        return JavaMethod.getMethod(declaringClass, new JavaMethodSignature(method));
    }

    public Object invoke(Object o, Object ... args) {
        return DomReflectionUtil.invokeMethod(this.myMethod, o, args);
    }

    public String toString() {
        return "JavaMethod: " + this.myMethod.toString();
    }

    @NonNls
    public String getName() {
        return this.myMethod.getName();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Object annotation = this.myAnnotationsMap.get(annotationClass);
        if (annotation == null) {
            annotation = this.findAnnotation(annotationClass);
            this.myAnnotationsMap = this.myAnnotationsMap.plus(annotationClass, annotation);
        }
        return (T)(annotation == NONE ? null : (Annotation)annotation);
    }

    @NotNull
    private Object findAnnotation(Class<? extends Annotation> annotationClass) {
        for (Method method : this.getHierarchy()) {
            Annotation annotation = method.getAnnotation(annotationClass);
            if (annotation == null) continue;
            Annotation annotation2 = annotation;
            if (annotation2 == null) {
                JavaMethod.$$$reportNull$$$0(2);
            }
            return annotation2;
        }
        Object object = NONE;
        if (object == null) {
            JavaMethod.$$$reportNull$$$0(3);
        }
        return object;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaMethod)) {
            return false;
        }
        JavaMethod that = (JavaMethod)o;
        if (!this.myDeclaringClass.equals(that.myDeclaringClass)) {
            return false;
        }
        return this.mySignature.equals(that.mySignature);
    }

    public int hashCode() {
        int result = this.mySignature.hashCode();
        result = 31 * result + this.myDeclaringClass.hashCode();
        return result;
    }

    public Class getReturnType() {
        return this.myMethod.getReturnType();
    }

    public Class<?>[] getParameterTypes() {
        return this.myMethod.getParameterTypes();
    }

    public int getParameterCount() {
        return this.myMethod.getParameterCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/JavaMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/JavaMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchy";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

