\name{Image}
\alias{Image}
\title{Image}
\Rdversion{1.1}
\docType{class}
\description{
The Image class for SimpleITK.
Image}
\details{
This Image class can represent 2D, 3D, and 4D images. The pixel types may be a
scalar, a multi-component vector or a run-length-encoded (RLE)
"label". The dimension, pixel type and size is specified at
construction.
A fundamental concept of ITK images is that they occupy physical space
where the image is defined by an origin, spacing, and direction cosine
matrix. The attributes are taken into consideration when doing most
operations on an image. A meta-data dictionary is also associated with
the image, which may contain additional fields from reading but these
attributes are not propagated by image filters.
The SimpleITK Image provides a single facade interface to several ITK image types.
Internally, the SimpleITK Image maintains a pointer to the ITK image class, and performs reference
counting and lazy copying. This means that deep copying of an image
including it's buffer is delayed until the image is modified. This
removes the need to use pointers to SimpleITK Image class, as copying and returning by value do not unnecessarily
duplicate the data.
/sa itk::Image itk::VectorImage itk::LabelMap itk::ImageBase
Image}
%C++ includes: sitkImage.h
\section{Methods}{
\describe{
\item{void CopyInformation(const Image &srcImage):}{
Copy common meta-data from an image to this one.
Copies the Origin, Spacing, and Direction from the source image to
this image. The meta-data dictionary is not copied.
It is required for the source Image's dimension and size to match, this image's attributes, otherwise an
exception will be generated.
}
\item{bool EraseMetaData(const std::string &key):}{
Remove an entry from the meta-data dictionary.
Returns true, when the value exists in the dictionary and is removed,
false otherwise.
}
\item{std::vector< double > EvaluateAtContinuousIndex(const std::vector< double > &index, InterpolatorEnum interp=sitkLinear) const:}{
Interpolate pixel value at a continuous index.
This method is not supported for Label pixel types.
The valid range of continuous index is [-0.5, size-0.5] for each
dimension. An exception is thrown if index is out of bounds.
Parameters:
index:
The continuous index must be at least the length of the image
dimension.
interp:
The interpolation type to use, only sitkNearest and sitkLinear are
supported for Vector and Complex pixel types.
All supported pixel types are returned as an array, where complex
numbers are returned with the real followed by the complex component.
}
\item{std::vector< double > EvaluateAtPhysicalPoint(const std::vector< double > &point, InterpolatorEnum interp=sitkLinear) const:}{
Interpolate pixel value at a physical point.
This method is not supported for Label pixel types.
An exception is thrown if the point is out of the defined region for
the image.
Parameters:
point:
The physical point at which the interpolation is computed.
interp:
The interpolation type to use, only sitkNearest and sitkLinear are
supported for Vector and Complex pixel types.
All supported pixel types are returned as an array, where complex
numbers are returned with the real followed by the complex component.
}
\item{unsigned int GetDepth() const:}{
Get the number of pixels the Image is in the third dimension or 0 if the Image is only 2D
}
\item{unsigned int GetDimension() const:}{
Get the number of physical dimensions.
Only the spatial dimensions are considered here. These are the
dimensions the origin, spacing and direction cosine matrix are
applicable to. This does not include the pixels' vector index as a
dimension.
}
\item{unsigned int GetHeight() const:}{
Get the number of pixels the Image is in the second dimension
}
\item{std::string GetMetaData(const std::string &key) const:}{
Get the value of a meta-data dictionary entry as a string.
If the key is not in the dictionary then an exception is thrown.
string types in the dictionary are returned as their native strings.
Other types are printed to string before returning.
}
\item{std::vector< std::string > GetMetaDataKeys() const:}{
get a vector of keys in from the meta-data dictionary
Returns a vector of keys to the key/value entries in the image's meta-
data dictionary. Iterate through with these keys to get the values.
}
\item{unsigned int GetNumberOfComponentsPerPixel() const:}{
Get the number of components for each pixel.
For images with scalar or complex pixel types this method returns one.
For images with a vector pixel type the method returns the number of
vector components per pixel.
}
\item{uint64_t GetNumberOfPixels() const:}{
Get the number of pixels in the image.
To calculate the total number of values stored continuously for the
image's buffer, the NumberOfPixels should be multiplied by
NumberOfComponentsPerPixel in order to account for multiple component
images.
}
\item{PixelIDValueEnum GetPixelID() const:}{
Get the pixel type
The pixel type is set at construction type and can not be manually
changed, unless by assignment. The value may be -1 or "Unknown".
}
\item{std::string GetPixelIDTypeAsString() const:}{
Return the pixel type as a human readable string value.
}
\item{PixelIDValueType GetPixelIDValue() const:}{}
\item{std::vector< unsigned int > GetSize() const:}{
Get the number of pixels the Image is in each dimension as a std::vector. The size of the vector is
equal to the number of dimensions for the image.
}
\item{unsigned int GetSizeOfPixelComponent() const:}{
Get the number of bytes per component of a pixel.
Returns the sizeof the pixel component type.
}
\item{unsigned int GetWidth() const:}{
Get the number of pixels the Image is in the first dimension
}
\item{bool HasMetaDataKey(const std::string &key) const:}{
Query the meta-data dictionary for the existence of a key.
}
\item{ Image():}{
Default constructor, creates an image of size 0.
}
\item{ Image(const Image &img):}{}
\item{ Image(Image &&img) noexcept:}{
Move constructor and assignment.
Parameters:
img:
After the operation img is valid only for destructing and assignment;
all other operations have undefined behavior.
}
\item{bool IsUnique() const:}{
Returns true if no other SimpleITK Image object refers to the same internal data structure.
}
\item{void MakeUnique():}{
Performs actually coping if needed to make object unique.
The Image class by default performs lazy coping and assignment. This method
make sure that coping actually happens to the itk::Image pointed to is only pointed to by this object.
}
\item{Image ProxyForInPlaceOperation():}{
Advanced method not commonly needed.
This method is designed to support implementations "in-place" object
behavior for methods which operate on r-value references. The returned
image is a new image which has a low level pointer to this object's
image buffer, without the SimpleITK or ITK reference counting. This is
implemented by setting the new ITK Image's buffer to the same as this objects without ownership.
WARNING:
This method bypasses the SimpleITK reference counting, and the
reference needs to be manually maintained in the scope. The resulting
object is designed only to be a temporary.
 In the following example this method is used instead of an std::move call when the filter's first argument takes an r-value reference. The img object will container the results of the filter execution, and the img image buffer will be preserved in case of exceptions, and the meta-
data will remain in the img object.
The meta-data dictionary is not copied to the returned proxy image.
}
\item{void SetMetaData(const std::string &key, const std::string &value):}{
Set an entry in the meta-data dictionary.
Replaces or creates an entry in the image's meta-data dictionary.
}
\item{Image ToScalarImage(bool inPlace=true):}{
Convert a image of vector pixel type to a scalar image with N+1
dimensions.
This method will convert a vector image to a scalar image with the
size of the first dimension equal to the number of components. If the
image is already a scalar image then the image is returned.
For the additional dimension the origin is set to zero, the spacing to
one, and the new components of the direction cosine to the identity
matrix.
An exception is thrown if the image is has SITK_MAX_DIMENSION
dimensions or if the pixel type is a label or complex pixel type.
Parameters:
inPlace:
If true then the image is made unique and converted in place updating
this image, otherwise a copy of the image is made and returned.
See:
ToVectorImage
}
\item{std::string ToString() const:}{}
\item{Image ToVectorImage(bool inPlace=true):}{
Convert the first dimension to the components for image with vector
pixel type.
This method will convert a scalar image to a vector image with the
number of components equal to the size of the first dimension. If the
image is already a vector image then the image is returned.
The components of the direction cosine matrix for the first dimension
must be the identity matrix, or else an exception is thrown.
An exception is thrown if the image is 2D or if the pixel type is a
label or complex pixel type.
Parameters:
inPlace:
If true then the image is made unique and converted in place updating
this image, otherwise a copy of the image is made and returned.
See:
ToScalarImage
}
\item{std::vector< double > TransformContinuousIndexToPhysicalPoint(const std::vector< double > &index) const:}{
Transform continuous index to physical point
}
\item{std::vector< double > TransformIndexToPhysicalPoint(const std::vector< int64_t > &index) const:}{
Transform index to physical point
}
\item{std::vector< double > TransformPhysicalPointToContinuousIndex(const std::vector< double > &point) const:}{
Transform physical point to continuous index
}
\item{std::vector< int64_t > TransformPhysicalPointToIndex(const std::vector< double > &point) const:}{
Transform physical point to index
}
\item{ ~Image():}{}
}
}
