/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.formatter.serialize;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Objects;
import schemacrawler.schema.Catalog;
import schemacrawler.tools.formatter.serialize.CatalogSerializer;
import schemacrawler.utility.SerializedCatalogUtility;

public final class JavaSerializedCatalog
implements CatalogSerializer {
    private final Catalog catalog;

    private static Catalog readCatalog(InputStream in) {
        Objects.requireNonNull(in, "No input stream provided");
        return SerializedCatalogUtility.readCatalog((InputStream)in);
    }

    public JavaSerializedCatalog(Catalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
    }

    public JavaSerializedCatalog(InputStream in) {
        this(JavaSerializedCatalog.readCatalog(in));
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public void save(OutputStream out) {
        Objects.requireNonNull(out, "No output stream provided");
        SerializedCatalogUtility.saveCatalog((Catalog)this.catalog, (OutputStream)out);
    }

    @Override
    public void save(Writer out) {
        throw new UnsupportedOperationException("Cannot serialize binary format using character data");
    }
}

