/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.Objects;
import schemacrawler.filter.TableTypesFilter;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.lint.LintSeverity;
import us.fatehi.utility.property.PropertyName;

class LinterTableWithPrimaryKeyNotFirst
extends BaseLinter {
    LinterTableWithPrimaryKeyNotFirst(PropertyName propertyName, LintCollector lintCollector) {
        super(propertyName, lintCollector);
        this.setSeverity(LintSeverity.low);
        this.setTableTypesFilter(new TableTypesFilter(new String[]{"TABLE"}));
    }

    @Override
    public String getSummary() {
        return "primary key not first";
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        PrimaryKey primaryKey = table.getPrimaryKey();
        if (primaryKey == null) {
            return;
        }
        for (TableConstraintColumn pkColumn : primaryKey.getConstrainedColumns()) {
            if (pkColumn.getTableConstraintOrdinalPosition() == pkColumn.getOrdinalPosition()) continue;
            this.addTableLint(table, this.getSummary());
            break;
        }
    }
}

