/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.downloader.destination;

import ir.amirab.util.platform.Platform;
import ir.amirab.util.platform.PlatformFInder;
import ir.amirab.util.platform.PlatformKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lir/amirab/downloader/destination/IncompleteFileUtil;", "", "<init>", "()V", "SYSTEM_MAXIMUM_FILE_LENGTH", "", "SYSTEM_MAXIMUM_FULL_PATH_LENGTH", "createExtension", "", "id", "", "addIncompleteIndicator", "Ljava/io/File;", "file", "core"})
public final class IncompleteFileUtil {
    @NotNull
    public static final IncompleteFileUtil INSTANCE = new IncompleteFileUtil();
    private static final int SYSTEM_MAXIMUM_FILE_LENGTH = 255;
    private static final int SYSTEM_MAXIMUM_FULL_PATH_LENGTH = 259;

    private IncompleteFileUtil() {
    }

    private final String createExtension(long id) {
        return ".dl-" + id + ".abdm.part";
    }

    @NotNull
    public final File addIncompleteIndicator(@NotNull File file, long id) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String ext = this.createExtension(id);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)ext, (boolean)false, (int)2, null)) {
            String string2;
            if (PlatformKt.isWindows((PlatformFInder)((PlatformFInder)Platform.Companion))) {
                int parentPathLength = file.getParentFile().getPath().length() + 1;
                String string3 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                string2 = StringsKt.take((String)string3, (int)RangesKt.coerceAtLeast((int)(259 - (parentPathLength + ext.length())), (int)0));
            } else {
                String string4 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                string2 = StringsKt.take((String)string4, (int)(255 - ext.length()));
            }
            String trimmedFileName = string2;
            File file2 = file.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
            return FilesKt.resolve((File)file2, (String)(trimmedFileName + ext));
        }
        return file;
    }
}

