/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.core;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.http4k.KotlinExtensionsKt;
import org.http4k.core.Credentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001.BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0003J\u0015\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0003J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u0018\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u0011\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0000H\u0096\u0002J\b\u0010 \u001a\u00020\u0003H\u0016J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010$\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003JV\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010)J\u0013\u0010*\u001a\u00020+2\b\u0010\u001f\u001a\u0004\u0018\u00010,H\u00d6\u0003J\t\u0010-\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006/"}, d2={"Lorg/http4k/core/Uri;", "", "scheme", "", "userInfo", "host", "port", "", "path", "query", "fragment", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getScheme", "()Ljava/lang/String;", "getUserInfo", "getHost", "getPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getPath", "getQuery", "getFragment", "authority", "getAuthority", "(Ljava/lang/Integer;)Lorg/http4k/core/Uri;", "credentials", "Lorg/http4k/core/Credentials;", "charset", "Ljava/nio/charset/Charset;", "compareTo", "other", "toString", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lorg/http4k/core/Uri;", "equals", "", "", "hashCode", "Companion", "http4k-core"})
public final class Uri
implements Comparable<Uri> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String scheme;
    @NotNull
    private final String userInfo;
    @NotNull
    private final String host;
    @Nullable
    private final Integer port;
    @NotNull
    private final String path;
    @NotNull
    private final String query;
    @NotNull
    private final String fragment;
    @NotNull
    private final String authority;
    @NotNull
    private static final Regex AUTHORITY = new Regex("(?:([^@]+)@)?([^:]+)(?::([\\d]+))?");
    @NotNull
    private static final Regex RFC3986 = new Regex("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?");

    public Uri(@NotNull String scheme, @NotNull String userInfo, @NotNull String host, @Nullable Integer port, @NotNull String path, @NotNull String query, @NotNull String fragment) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.scheme = scheme;
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
        this.fragment = fragment;
        String[] stringArray = new String[]{this.userInfo, "@"};
        StringBuilder stringBuilder = KotlinExtensionsKt.appendIfNotBlank(new StringBuilder(), this.userInfo, stringArray);
        stringArray = new String[]{this.host};
        StringBuilder stringBuilder2 = KotlinExtensionsKt.appendIfNotBlank(stringBuilder, this.host, stringArray);
        stringArray = new String[]{":", String.valueOf(this.port)};
        String string = KotlinExtensionsKt.appendIfPresent(stringBuilder2, this.port, stringArray).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.authority = string;
    }

    @NotNull
    public final String getScheme() {
        return this.scheme;
    }

    @NotNull
    public final String getUserInfo() {
        return this.userInfo;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @Nullable
    public final Integer getPort() {
        return this.port;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getQuery() {
        return this.query;
    }

    @NotNull
    public final String getFragment() {
        return this.fragment;
    }

    @NotNull
    public final String getAuthority() {
        return this.authority;
    }

    @NotNull
    public final Uri scheme(@NotNull String scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return Uri.copy$default(this, scheme, null, null, null, null, null, null, 126, null);
    }

    @NotNull
    public final Uri userInfo(@NotNull String userInfo) {
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        return Uri.copy$default(this, null, userInfo, null, null, null, null, null, 125, null);
    }

    @NotNull
    public final Uri host(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return Uri.copy$default(this, null, null, host, null, null, null, null, 123, null);
    }

    @NotNull
    public final Uri port(@Nullable Integer port) {
        return Uri.copy$default(this, null, null, null, port, null, null, null, 119, null);
    }

    @NotNull
    public final Uri path(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Uri.copy$default(this, null, null, null, null, path, null, null, 111, null);
    }

    @NotNull
    public final Uri query(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return Uri.copy$default(this, null, null, null, null, null, query, null, 95, null);
    }

    @NotNull
    public final Uri fragment(@NotNull String fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        return Uri.copy$default(this, null, null, null, null, null, null, fragment, 63, null);
    }

    @NotNull
    public final Uri authority(@NotNull String authority) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        Triple triple = Uri.Companion.parseAuthority(authority);
        boolean bl = false;
        String userInfo = (String)triple.component1();
        String host = (String)triple.component2();
        Integer port = (Integer)triple.component3();
        return Uri.copy$default(this, null, userInfo, host, port, null, null, null, 113, null);
    }

    @NotNull
    public final Uri credentials(@NotNull Credentials credentials, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        String encodedUsername = URLEncoder.encode(credentials.getUser(), charset);
        String encodedPassword = URLEncoder.encode(credentials.getPassword(), charset);
        return this.userInfo(encodedUsername + ":" + encodedPassword);
    }

    public static /* synthetic */ Uri credentials$default(Uri uri2, Credentials credentials, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return uri2.credentials(credentials, charset);
    }

    @Nullable
    public final Credentials credentials(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        String[] stringArray = new String[]{":"};
        List parts = StringsKt.split$default((CharSequence)this.userInfo, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() != 2) {
            return null;
        }
        String string = URLDecoder.decode((String)parts.get(0), charset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        String string2 = URLDecoder.decode((String)parts.get(1), charset);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"decode(...)");
        return new Credentials(string, string2);
    }

    public static /* synthetic */ Credentials credentials$default(Uri uri2, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return uri2.credentials(charset);
    }

    @Override
    public int compareTo(@NotNull Uri other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.toString().compareTo(other.toString());
    }

    @NotNull
    public String toString() {
        String[] stringArray = new String[]{this.scheme, ":"};
        StringBuilder stringBuilder = KotlinExtensionsKt.appendIfNotBlank(new StringBuilder(), this.scheme, stringArray);
        stringArray = new String[]{"//", this.authority};
        StringBuilder stringBuilder2 = KotlinExtensionsKt.appendIfNotBlank(stringBuilder, this.authority, stringArray).append((String)(StringsKt.isBlank((CharSequence)this.authority) ? this.path : (StringsKt.isBlank((CharSequence)this.path) || StringsKt.startsWith$default((String)this.path, (String)"/", (boolean)false, (int)2, null) ? this.path : "/" + this.path)));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        String[] stringArray2 = new String[]{"?", this.query};
        StringBuilder stringBuilder3 = KotlinExtensionsKt.appendIfNotBlank(stringBuilder2, this.query, stringArray2);
        stringArray2 = new String[]{"#", this.fragment};
        String string = KotlinExtensionsKt.appendIfNotBlank(stringBuilder3, this.fragment, stringArray2).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String component1() {
        return this.scheme;
    }

    @NotNull
    public final String component2() {
        return this.userInfo;
    }

    @NotNull
    public final String component3() {
        return this.host;
    }

    @Nullable
    public final Integer component4() {
        return this.port;
    }

    @NotNull
    public final String component5() {
        return this.path;
    }

    @NotNull
    public final String component6() {
        return this.query;
    }

    @NotNull
    public final String component7() {
        return this.fragment;
    }

    @NotNull
    public final Uri copy(@NotNull String scheme, @NotNull String userInfo, @NotNull String host, @Nullable Integer port, @NotNull String path, @NotNull String query, @NotNull String fragment) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        return new Uri(scheme, userInfo, host, port, path, query, fragment);
    }

    public static /* synthetic */ Uri copy$default(Uri uri2, String string, String string2, String string3, Integer n, String string4, String string5, String string6, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = uri2.scheme;
        }
        if ((n2 & 2) != 0) {
            string2 = uri2.userInfo;
        }
        if ((n2 & 4) != 0) {
            string3 = uri2.host;
        }
        if ((n2 & 8) != 0) {
            n = uri2.port;
        }
        if ((n2 & 0x10) != 0) {
            string4 = uri2.path;
        }
        if ((n2 & 0x20) != 0) {
            string5 = uri2.query;
        }
        if ((n2 & 0x40) != 0) {
            string6 = uri2.fragment;
        }
        return uri2.copy(string, string2, string3, n, string4, string5, string6);
    }

    public int hashCode() {
        int result = this.scheme.hashCode();
        result = result * 31 + this.userInfo.hashCode();
        result = result * 31 + this.host.hashCode();
        result = result * 31 + (this.port == null ? 0 : ((Object)this.port).hashCode());
        result = result * 31 + this.path.hashCode();
        result = result * 31 + this.query.hashCode();
        result = result * 31 + this.fragment.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Uri)) {
            return false;
        }
        Uri uri2 = (Uri)other;
        if (!Intrinsics.areEqual((Object)this.scheme, (Object)uri2.scheme)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.userInfo, (Object)uri2.userInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.host, (Object)uri2.host)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.port, (Object)uri2.port)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)uri2.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.query, (Object)uri2.query)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fragment, (Object)uri2.fragment);
    }

    @JvmStatic
    @NotNull
    public static final Uri of(@NotNull String value2) {
        return Companion.of(value2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J$\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/http4k/core/Uri$Companion;", "", "<init>", "()V", "AUTHORITY", "Lkotlin/text/Regex;", "RFC3986", "of", "Lorg/http4k/core/Uri;", "value", "", "parseAuthority", "Lkotlin/Triple;", "", "authority", "http4k-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Uri of(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            MatchResult matchResult = RFC3986.matchEntire((CharSequence)value2);
            if (matchResult == null) {
                throw new RuntimeException("Invalid Uri: " + value2);
            }
            MatchResult result = matchResult;
            MatchResult.Destructured destructured = result.getDestructured();
            String scheme = (String)destructured.getMatch().getGroupValues().get(1);
            String authority = (String)destructured.getMatch().getGroupValues().get(2);
            String path = (String)destructured.getMatch().getGroupValues().get(3);
            String query = (String)destructured.getMatch().getGroupValues().get(4);
            String fragment = (String)destructured.getMatch().getGroupValues().get(5);
            Triple<String, String, Integer> triple = this.parseAuthority(authority);
            String userInfo = (String)triple.component1();
            String host = (String)triple.component2();
            Integer port = (Integer)triple.component3();
            return new Uri(scheme, userInfo, host, port, path, query, fragment);
        }

        private final Triple<String, String, Integer> parseAuthority(String authority) {
            Triple triple;
            if (StringsKt.isBlank((CharSequence)authority)) {
                triple = new Triple((Object)"", (Object)"", null);
            } else {
                MatchResult matchResult = AUTHORITY.matchEntire((CharSequence)authority);
                if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
                    throw new RuntimeException("Invalid authority: " + authority);
                }
                MatchResult matchResult2 = matchResult;
                String userInfo = (String)matchResult2.getMatch().getGroupValues().get(1);
                String host = (String)matchResult2.getMatch().getGroupValues().get(2);
                String portString = (String)matchResult2.getMatch().getGroupValues().get(3);
                Integer port = StringsKt.toIntOrNull((String)portString);
                triple = new Triple((Object)userInfo, (Object)host, (Object)port);
            }
            return triple;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

