/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.desktop.pages.editdownload;

import androidx.compose.runtime.internal.StabilityInferred;
import com.abdownloadmanager.desktop.pages.editdownload.CanEditDownloadResult;
import com.abdownloadmanager.desktop.pages.editdownload.CanEditWarnings;
import com.abdownloadmanager.desktop.pages.editdownload.DownloadConflictDetector;
import ir.amirab.downloader.downloaditem.DownloadItem;
import ir.amirab.util.FileNameValidator;
import ir.amirab.util.UrlUtils;
import ir.amirab.util.flow.StateFlowUtilKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001BC\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u0016\u001a\u00020\u0017J'\u0010\u0016\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\u001cR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/abdownloadmanager/desktop/pages/editdownload/EditDownloadChecker;", "", "currentDownloadItem", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lir/amirab/downloader/downloaditem/DownloadItem;", "editedDownloadItem", "newLengthFlow", "Lkotlinx/coroutines/flow/StateFlow;", "", "conflictDetector", "Lcom/abdownloadmanager/desktop/pages/editdownload/DownloadConflictDetector;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/flow/MutableStateFlow;Lkotlinx/coroutines/flow/MutableStateFlow;Lkotlinx/coroutines/flow/StateFlow;Lcom/abdownloadmanager/desktop/pages/editdownload/DownloadConflictDetector;Lkotlinx/coroutines/CoroutineScope;)V", "getCurrentDownloadItem", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "getEditedDownloadItem", "getNewLengthFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "getConflictDetector", "()Lcom/abdownloadmanager/desktop/pages/editdownload/DownloadConflictDetector;", "check", "", "Lcom/abdownloadmanager/desktop/pages/editdownload/CanEditDownloadResult;", "current", "edited", "newLength", "(Lir/amirab/downloader/downloaditem/DownloadItem;Lir/amirab/downloader/downloaditem/DownloadItem;Ljava/lang/Long;)Lcom/abdownloadmanager/desktop/pages/editdownload/CanEditDownloadResult;", "_canEditResult", "canEditResult", "getCanEditResult", "canEdit", "", "getCanEdit", "app"})
@StabilityInferred(parameters=0)
public final class EditDownloadChecker {
    @NotNull
    private final MutableStateFlow<DownloadItem> currentDownloadItem;
    @NotNull
    private final MutableStateFlow<DownloadItem> editedDownloadItem;
    @NotNull
    private final StateFlow<Long> newLengthFlow;
    @NotNull
    private final DownloadConflictDetector conflictDetector;
    @NotNull
    private final MutableStateFlow<CanEditDownloadResult> _canEditResult;
    @NotNull
    private final StateFlow<CanEditDownloadResult> canEditResult;
    @NotNull
    private final StateFlow<Boolean> canEdit;
    public static final int $stable = 8;

    public EditDownloadChecker(@NotNull MutableStateFlow<DownloadItem> currentDownloadItem, @NotNull MutableStateFlow<DownloadItem> editedDownloadItem, @NotNull StateFlow<Long> newLengthFlow, @NotNull DownloadConflictDetector conflictDetector, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter(currentDownloadItem, (String)"currentDownloadItem");
        Intrinsics.checkNotNullParameter(editedDownloadItem, (String)"editedDownloadItem");
        Intrinsics.checkNotNullParameter(newLengthFlow, (String)"newLengthFlow");
        Intrinsics.checkNotNullParameter((Object)conflictDetector, (String)"conflictDetector");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.currentDownloadItem = currentDownloadItem;
        this.editedDownloadItem = editedDownloadItem;
        this.newLengthFlow = newLengthFlow;
        this.conflictDetector = conflictDetector;
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)this.editedDownloadItem), (Function2)((Function2)new Function2<DownloadItem, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ EditDownloadChecker this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0._canEditResult.setValue((Object)CanEditDownloadResult.Waiting.INSTANCE);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(DownloadItem p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)scope);
        this._canEditResult = StateFlowKt.MutableStateFlow((Object)CanEditDownloadResult.NothingChanged.INSTANCE);
        this.canEditResult = FlowKt.asStateFlow(this._canEditResult);
        this.canEdit = StateFlowUtilKt.mapStateFlow(this.canEditResult, EditDownloadChecker::canEdit$lambda$0);
    }

    @NotNull
    public final MutableStateFlow<DownloadItem> getCurrentDownloadItem() {
        return this.currentDownloadItem;
    }

    @NotNull
    public final MutableStateFlow<DownloadItem> getEditedDownloadItem() {
        return this.editedDownloadItem;
    }

    @NotNull
    public final StateFlow<Long> getNewLengthFlow() {
        return this.newLengthFlow;
    }

    @NotNull
    public final DownloadConflictDetector getConflictDetector() {
        return this.conflictDetector;
    }

    public final void check() {
        this._canEditResult.setValue((Object)CanEditDownloadResult.Waiting.INSTANCE);
        this._canEditResult.setValue((Object)this.check((DownloadItem)this.currentDownloadItem.getValue(), (DownloadItem)this.editedDownloadItem.getValue(), (Long)this.newLengthFlow.getValue()));
    }

    private final CanEditDownloadResult check(DownloadItem current, DownloadItem edited, Long newLength) {
        if (Intrinsics.areEqual((Object)current, (Object)edited)) {
            return CanEditDownloadResult.NothingChanged.INSTANCE;
        }
        if (!UrlUtils.INSTANCE.isValidUrl(edited.getLink())) {
            return CanEditDownloadResult.InvalidURL.INSTANCE;
        }
        if (!Intrinsics.areEqual((Object)edited.getName(), (Object)current.getName())) {
            if (!FileNameValidator.INSTANCE.isValidFileName(edited.getName())) {
                return CanEditDownloadResult.InvalidFileName.INSTANCE;
            }
            if (this.conflictDetector.checkAlreadyExists(current, edited)) {
                return CanEditDownloadResult.FileNameAlreadyExists.INSTANCE;
            }
        }
        List warnings = new ArrayList();
        Long l = newLength;
        if (l == null || current.getContentLength() != l.longValue()) {
            Long l2 = newLength;
            warnings.add(new CanEditWarnings.FileSizeNotMatch(current.getContentLength(), l2 != null ? l2 : -1L));
        }
        return new CanEditDownloadResult.CanEdit(warnings);
    }

    @NotNull
    public final StateFlow<CanEditDownloadResult> getCanEditResult() {
        return this.canEditResult;
    }

    @NotNull
    public final StateFlow<Boolean> getCanEdit() {
        return this.canEdit;
    }

    private static final boolean canEdit$lambda$0(CanEditDownloadResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof CanEditDownloadResult.CanEdit;
    }
}

