/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableSet;

import androidx.compose.runtime.external.kotlinx.collections.immutable.PersistentSet;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSet;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetMutableIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableSet.TrieNode;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.DeltaCounter;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.MutabilityOwnership;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableSet;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010)\n\u0000\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001f\u001a\u00020\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0016J\u0016\u0010\"\u001a\u00020\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0016J\u0016\u0010#\u001a\u00020\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0016J\u0016\u0010$\u001a\u00020\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0016J\u0015\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010&\u001a\u00020'H\u0016J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0096\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\r@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0011@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0011@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0014\"\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableSet/PersistentHashSetBuilder;", "E", "Lkotlin/collections/AbstractMutableSet;", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentSet$Builder;", "set", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableSet/PersistentHashSet;", "<init>", "(Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableSet/PersistentHashSet;)V", "value", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/internal/MutabilityOwnership;", "ownership", "getOwnership$runtime", "()Landroidx/compose/runtime/external/kotlinx/collections/immutable/internal/MutabilityOwnership;", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableSet/TrieNode;", "node", "getNode$runtime", "()Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableSet/TrieNode;", "", "modCount", "getModCount$runtime", "()I", "size", "getSize", "setSize", "(I)V", "build", "contains", "", "element", "(Ljava/lang/Object;)Z", "add", "addAll", "elements", "", "retainAll", "removeAll", "containsAll", "remove", "clear", "", "iterator", "", "runtime"})
@StabilityInferred(parameters=0)
public final class PersistentHashSetBuilder<E>
extends AbstractMutableSet<E>
implements PersistentSet.Builder<E> {
    @NotNull
    private PersistentHashSet<E> set;
    @NotNull
    private MutabilityOwnership ownership;
    @NotNull
    private TrieNode<E> node;
    private int modCount;
    private int size;
    public static final int $stable = 8;

    public PersistentHashSetBuilder(@NotNull PersistentHashSet<E> set) {
        this.set = set;
        this.ownership = new MutabilityOwnership();
        this.node = this.set.getNode$runtime();
        this.size = this.set.size();
    }

    @NotNull
    public final MutabilityOwnership getOwnership$runtime() {
        return this.ownership;
    }

    @NotNull
    public final TrieNode<E> getNode$runtime() {
        return this.node;
    }

    public final int getModCount$runtime() {
        return this.modCount;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int value) {
        this.size = value;
        int n = this.modCount;
        this.modCount = n + 1;
    }

    @Override
    @NotNull
    public PersistentHashSet<E> build() {
        PersistentHashSet<E> persistentHashSet;
        if (this.node == this.set.getNode$runtime()) {
            persistentHashSet = this.set;
        } else {
            this.ownership = new MutabilityOwnership();
            persistentHashSet = new PersistentHashSet<E>(this.node, this.size());
        }
        this.set = persistentHashSet;
        return this.set;
    }

    @Override
    public boolean contains(Object element) {
        Object object = element;
        return this.node.contains(object != null ? object.hashCode() : 0, element, 0);
    }

    @Override
    public boolean add(E element) {
        int size = this.size();
        E e = element;
        this.node = this.node.mutableAdd(e != null ? e.hashCode() : 0, element, 0, this);
        return size != this.size();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> elements) {
        PersistentHashSet set;
        PersistentSet persistentSet = elements instanceof PersistentHashSet ? (PersistentHashSet)elements : null;
        if (persistentSet == null) {
            PersistentHashSetBuilder persistentHashSetBuilder = elements instanceof PersistentHashSetBuilder ? (PersistentHashSetBuilder)elements : null;
            persistentSet = persistentHashSetBuilder != null ? persistentHashSetBuilder.build() : null;
        }
        if ((set = persistentSet) != null) {
            DeltaCounter deltaCounter = new DeltaCounter(0, 1, null);
            int size = this.size();
            TrieNode<E> result = this.node.mutableAddAll(set.getNode$runtime(), 0, deltaCounter, this);
            int newSize = size + elements.size() - deltaCounter.getCount();
            if (size != newSize) {
                this.node = result;
                this.setSize(newSize);
            }
            return size != this.size();
        }
        return super.addAll(elements);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> elements) {
        PersistentHashSet set;
        PersistentSet persistentSet = elements instanceof PersistentHashSet ? (PersistentHashSet)elements : null;
        if (persistentSet == null) {
            PersistentHashSetBuilder persistentHashSetBuilder = elements instanceof PersistentHashSetBuilder ? (PersistentHashSetBuilder)elements : null;
            persistentSet = persistentHashSetBuilder != null ? persistentHashSetBuilder.build() : null;
        }
        if ((set = persistentSet) != null) {
            DeltaCounter deltaCounter = new DeltaCounter(0, 1, null);
            int size = this.size();
            Object result = this.node.mutableRetainAll(set.getNode$runtime(), 0, deltaCounter, this);
            int newSize = deltaCounter.getCount();
            if (newSize == 0) {
                this.clear();
            } else if (newSize != size) {
                Intrinsics.checkNotNull((Object)result, (String)"null cannot be cast to non-null type androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableSet.TrieNode<E of androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetBuilder>");
                this.node = (TrieNode)result;
                this.setSize(newSize);
            }
            return size != this.size();
        }
        return super.retainAll(elements);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> elements) {
        PersistentHashSet set;
        PersistentSet persistentSet = elements instanceof PersistentHashSet ? (PersistentHashSet)elements : null;
        if (persistentSet == null) {
            PersistentHashSetBuilder persistentHashSetBuilder = elements instanceof PersistentHashSetBuilder ? (PersistentHashSetBuilder)elements : null;
            persistentSet = persistentHashSetBuilder != null ? persistentHashSetBuilder.build() : null;
        }
        if ((set = persistentSet) != null) {
            DeltaCounter counter = new DeltaCounter(0, 1, null);
            int size = this.size();
            Object result = this.node.mutableRemoveAll(set.getNode$runtime(), 0, counter, this);
            int newSize = size - counter.getCount();
            if (newSize == 0) {
                this.clear();
            } else if (newSize != size) {
                Intrinsics.checkNotNull((Object)result, (String)"null cannot be cast to non-null type androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableSet.TrieNode<E of androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetBuilder>");
                this.node = (TrieNode)result;
                this.setSize(newSize);
            }
            return size != this.size();
        }
        return super.removeAll(elements);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        if (elements instanceof PersistentHashSet) {
            return this.node.containsAll(((PersistentHashSet)elements).getNode$runtime(), 0);
        }
        if (elements instanceof PersistentHashSetBuilder) {
            return this.node.containsAll(((PersistentHashSetBuilder)elements).node, 0);
        }
        return super.containsAll(elements);
    }

    @Override
    public boolean remove(Object element) {
        int size = this.size();
        Object object = element;
        this.node = this.node.mutableRemove(object != null ? object.hashCode() : 0, element, 0, this);
        return size != this.size();
    }

    @Override
    public void clear() {
        TrieNode trieNode = TrieNode.Companion.getEMPTY$runtime();
        Intrinsics.checkNotNull((Object)trieNode, (String)"null cannot be cast to non-null type androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableSet.TrieNode<E of androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetBuilder>");
        this.node = trieNode;
        this.setSize(0);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new PersistentHashSetMutableIterator(this);
    }
}

