/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor.util;

import com.jthemedetecor.OsThemeDetector;
import io.github.g00fy2.versioncompare.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.PlatformEnum;
import oshi.SystemInfo;
import oshi.software.os.OperatingSystem;

public class OsInfo {
    private static final Logger logger = LoggerFactory.getLogger(OsThemeDetector.class);
    private static final PlatformEnum platformType;
    private static final String family;
    private static final String version;

    public static boolean isWindows10OrLater() {
        return OsInfo.hasTypeAndVersionOrHigher(PlatformEnum.WINDOWS, "10");
    }

    public static boolean isLinux() {
        return OsInfo.hasType(PlatformEnum.LINUX);
    }

    public static boolean isMacOsMojaveOrLater() {
        return OsInfo.hasTypeAndVersionOrHigher(PlatformEnum.MACOS, "10.14");
    }

    public static boolean isGnome() {
        return OsInfo.isLinux() && (OsInfo.queryResultContains("echo $XDG_CURRENT_DESKTOP", "gnome") || OsInfo.queryResultContains("echo $XDG_DATA_DIRS | grep -Eo 'gnome'", "gnome") || OsInfo.queryResultContains("ps -e | grep -E -i \"gnome\"", "gnome"));
    }

    public static boolean hasType(PlatformEnum platformType) {
        return OsInfo.platformType.equals((Object)platformType);
    }

    public static boolean isVersionAtLeast(String version) {
        return new Version(OsInfo.version).isAtLeast(version);
    }

    public static boolean hasTypeAndVersionOrHigher(PlatformEnum platformType, String version) {
        return OsInfo.hasType(platformType) && OsInfo.isVersionAtLeast(version);
    }

    public static String getVersion() {
        return version;
    }

    public static String getFamily() {
        return family;
    }

    private static boolean queryResultContains(@NotNull String cmd, @NotNull String subResult) {
        return OsInfo.query(cmd).toLowerCase().contains(subResult);
    }

    @NotNull
    private static String query(@NotNull String cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            StringBuilder stringBuilder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String actualReadLine;
                while ((actualReadLine = reader.readLine()) != null) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append(actualReadLine);
                }
            }
            return stringBuilder.toString();
        }
        catch (IOException e) {
            logger.error("Exception caught while querying the OS", (Throwable)e);
            return "";
        }
    }

    private OsInfo() {
    }

    static {
        SystemInfo systemInfo = new SystemInfo();
        OperatingSystem osInfo = systemInfo.getOperatingSystem();
        OperatingSystem.OSVersionInfo osVersionInfo = osInfo.getVersionInfo();
        platformType = SystemInfo.getCurrentPlatform();
        family = osInfo.getFamily();
        version = osVersionInfo.getVersion();
    }
}

