define(["exports","./../emby-apiclient/connectionmanager.js","./../browser.js","./../common/appsettings.js","./../emby-apiclient/events.js"],function(_exports,_connectionmanager,_browser,_appsettings,_events){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var recoverDecodingErrorDate,recoverSwapAudioCodecDate,isNativeLG="webos"===globalThis.appMode;function BaseHtmlPlayer(){this.type="mediaplayer",this.boundOnVolumeChange=function(e){var _instance$_currentPla,e=e.target;this._isFadingOut||(null!=(_instance$_currentPla=this._currentPlayOptions)&&_instance$_currentPla.fullscreen&&this.useElementVolume()&&_appsettings.default.volume(100*e.volume),_events.default.trigger(this,"volumechange"))}.bind(this),this.boundOnWaiting=function(e){_events.default.trigger(this,"waiting")}.bind(this),this.boundOnRateChange=function(){_events.default.trigger(this,"playbackratechange")}.bind(this),this.boundOnPlay=function(e){_events.default.trigger(this,"unpause")}.bind(this),this.boundOnPause=function(){_events.default.trigger(this,"pause")}.bind(this),this.boundOnEnded=function(e){this.onEnded(e.target)}.bind(this),this.boundOnError=onError.bind(this),this.boundOnTimeUpdate=function(e){e=e.target;{var time;this._started&&!this._isFadingOut&&((time=e.currentTime)&&!this._timeUpdated&&(this._timeUpdated=!0,this.onTimeUpdate(e,time,!0)),this._currentTime=time,this.onTimeUpdate(e,time),_events.default.trigger(this,"timeupdate"))}}.bind(this),this.boundOnPlaying=function(e){e=e.target;this._started||(this._started=!0,this.onStartedPlaying(e));_events.default.trigger(this,"playing")}.bind(this)}function isValidDuration(duration){return!(!duration||isNaN(duration)||duration===Number.POSITIVE_INFINITY||duration===Number.NEGATIVE_INFINITY)}function getRanges(instance,elem,timeRanges){for(var ranges=[],instance=instance._currentPlayOptions,offset=(offset=instance?instance.transcodingOffsetTicks:offset)||0,i=0,length=timeRanges.length;i<length;i++){var start=timeRanges.start(i),end=timeRanges.end(i);isValidDuration(start)||(start=0),isValidDuration(end)?ranges.push({start:1e7*start+offset,end:1e7*end+offset}):end=0}return ranges}function getPosterUrl(item){var imageOptions={};return function(item,options){if(item)return"Episode"!==item.Type?null:((options=options||{}).type=options.type||"Primary","Primary"===options.type&&item.SeriesPrimaryImageTag?(options.tag=item.SeriesPrimaryImageTag,_connectionmanager.default.getApiClient(item).getImageUrl(item.SeriesId,options)):"Thumb"===options.type&&item.ParentThumbImageTag?(options.tag=item.ParentThumbImageTag,_connectionmanager.default.getApiClient(item).getImageUrl(item.ParentThumbItemId,options)):null);throw new Error("item cannot be null!")}(item,imageOptions)||function(item,options){if(!item)throw new Error("item cannot be null!");(options=options||{}).type=options.type||"Primary";var imageTags=item.ImageTags||{};return options.tag=item.PrimaryImageTag||imageTags[options.type],options.tag?_connectionmanager.default.getApiClient(item).getImageUrl(item.PrimaryImageItemId||item.Id||item.ItemId,options):item.AlbumId&&item.AlbumPrimaryImageTag?(options.tag=item.AlbumPrimaryImageTag,_connectionmanager.default.getApiClient(item).getImageUrl(item.AlbumId,options)):null}(item,imageOptions)}function setCurrentTimeIfNeeded(element,seconds,allowance){Math.abs((element.currentTime||0)-seconds)>=allowance&&(element.currentTime=seconds)}function rejectWithError(reject,errorCode){var e=new Error("Playback failure");errorCode&&(e.name=errorCode),reject(e)}function bindEventsToHlsPlayer(instance,hls,elem,resolve,reject){hls.on(Hls.Events.MANIFEST_PARSED,function(){instance.playWithPromise(elem).then(function(result){reject=null,resolve(result)},function(){reject&&(reject(),reject=null)})}),hls.on(Hls.Events.ERROR,function(event,data){if(console.log("HLS Error: Type: "+data.type+" Details: "+(data.details||"")+" Fatal: "+(data.fatal||!1)+" Reason: "+(data.reason||"")),data.type===Hls.ErrorTypes.NETWORK_ERROR)if(data.response&&data.response.code&&400<=data.response.code)return console.log("hls.js response error code: "+data.response.code),hls.destroy(),void(reject?(rejectWithError(reject,"servererror"),reject=null):instance.onError("servererror"));if(data.fatal||reject)switch(data.type){case Hls.ErrorTypes.NETWORK_ERROR:reject||data.response&&0===data.response.code?(data.response&&console.log("hls.js response error code: "+data.response.code),hls.destroy(),reject?(rejectWithError(reject,"network"),reject=null):instance.onError("network")):(console.log("fatal network error encountered, try to recover"),hls.startLoad());break;case Hls.ErrorTypes.MEDIA_ERROR:console.log("media error encountered, try to recover");var currentReject=reject;reject=null,currentReject?rejectWithError(currentReject,"mediadecodeerror"):handleHlsJsMediaError(instance,currentReject);break;default:console.log("Cannot recover from hls error - destroy and trigger error"),hls.destroy(),reject?(rejectWithError(reject,"mediadecodeerror"),reject=null):instance.onError("mediadecodeerror")}})}function handleHlsJsMediaError(instance,reject){var now,hlsPlayer=instance._hlsPlayer;hlsPlayer&&(now=Date.now(),window.performance&&window.performance.now&&(now=performance.now()),!recoverDecodingErrorDate||3e3<now-recoverDecodingErrorDate?(recoverDecodingErrorDate=now,console.log("try to recover media Error ..."),hlsPlayer.recoverMediaError()):!recoverSwapAudioCodecDate||3e3<now-recoverSwapAudioCodecDate?(recoverSwapAudioCodecDate=now,console.log("try to swap Audio Codec and recover media Error ..."),hlsPlayer.swapAudioCodec(),hlsPlayer.recoverMediaError()):(console.error("cannot recover, last media error recovery failed ..."),reject?rejectWithError(reject,"mediadecodeerror"):instance.onError("mediadecodeerror")))}function onError(e){var type,e=e.target.error,errorCode=(null==e?void 0:e.code)||0,e=(null==e?void 0:e.message)||"";switch(console.log("Media element error: "+errorCode.toString()+" "+e),errorCode){case 1:return;case 2:type="network";break;case 3:if(this._hlsPlayer)return void handleHlsJsMediaError(this);type="mediadecodeerror";break;case 4:type="medianotsupported";break;default:return}this.onError(type)}function onSuccessfulPlay(instance,elem){instance.removeErrorEventListener(elem),elem.addEventListener("error",onError)}BaseHtmlPlayer.prototype.canPlayMediaType=function(mediaType){return(mediaType||"").toLowerCase()===this.mediaType},BaseHtmlPlayer.prototype.currentSrc=function(){return this._currentSrc},BaseHtmlPlayer.prototype.getDeviceProfile=function(item,options){var instance=this;return function(item){return Emby.importModule("./modules/browserdeviceprofile.js").then(function(profileBuilder){return profileBuilder({item:item})})}(item).then(function(profile){return instance._lastProfile=profile})},BaseHtmlPlayer.prototype.currentTime=function(val){var mediaElement=this._mediaElement;if(mediaElement){if(null==val){var currentTime=this._currentTime;if(currentTime)return 1e3*currentTime;if(!this._timeUpdated){currentTime=null==(currentTime=this._currentPlayOptions)?void 0:currentTime.playerStartPositionTicks;if(null!=currentTime)return currentTime/1e4}return 1e3*(mediaElement.currentTime||0)}mediaElement.currentTime=val/1e3}},BaseHtmlPlayer.prototype.duration=function(val){var mediaElement=this._mediaElement;if(mediaElement){mediaElement=mediaElement.duration;if(isValidDuration(mediaElement))return 1e3*mediaElement}return null},BaseHtmlPlayer.prototype.getBufferedRanges=function(){var mediaElement=this._mediaElement;return mediaElement?getRanges(this,0,mediaElement.buffered||[]):[]},BaseHtmlPlayer.prototype.getSeekableRanges=function(){var mediaElement=this._mediaElement;return mediaElement?getRanges(this,0,mediaElement.seekable||[]):[]},BaseHtmlPlayer.prototype.pause=function(){var mediaElement=this._mediaElement;mediaElement&&mediaElement.pause()},BaseHtmlPlayer.prototype.resume=function(){var mediaElement=this._mediaElement;mediaElement&&mediaElement.play()},BaseHtmlPlayer.prototype.unpause=function(){var mediaElement=this._mediaElement;mediaElement&&mediaElement.play()},BaseHtmlPlayer.prototype.paused=function(){var mediaElement=this._mediaElement;return!!mediaElement&&mediaElement.paused},BaseHtmlPlayer.prototype.useElementVolume=function(val){return!_browser.default.chromecast},BaseHtmlPlayer.prototype.setVolume=function(val){var mediaElement;_browser.default.chromecast?cast.framework.CastReceiverContext.getInstance().setSystemVolumeLevel(val/100):(mediaElement=this._mediaElement)&&(mediaElement.volume=val/100)},BaseHtmlPlayer.prototype.getVolume=function(){var mediaElement;return _browser.default.chromecast?100*cast.framework.CastReceiverContext.getInstance().getSystemVolume().level:(mediaElement=this._mediaElement)?Math.min(Math.round(100*mediaElement.volume),100):void 0},BaseHtmlPlayer.prototype.setPlaybackRate=function(val){var mediaElement=this._mediaElement;mediaElement&&(mediaElement.playbackRate=val)},BaseHtmlPlayer.prototype.getPlaybackRate=function(){var mediaElement=this._mediaElement;if(mediaElement)return mediaElement.playbackRate},BaseHtmlPlayer.prototype.volumeUp=function(){isNativeLG?webOS.service.request("luna://com.webos.audio",{method:"volumeUp"}):this.setVolume(Math.min(this.getVolume()+2,100))},BaseHtmlPlayer.prototype.volumeDown=function(){isNativeLG?webOS.service.request("luna://com.webos.audio",{method:"volumeDown"}):this.setVolume(Math.max(this.getVolume()-2,0))},BaseHtmlPlayer.prototype.setMute=function(mute){var mediaElement=this._mediaElement;mediaElement&&(mediaElement.muted=mute)},BaseHtmlPlayer.prototype.isMuted=function(){var mediaElement=this._mediaElement;return!!mediaElement&&mediaElement.muted},BaseHtmlPlayer.prototype.seekable=function(){var start,mediaElement=this._mediaElement;if(mediaElement)return!(!(mediaElement=mediaElement.seekable)||!mediaElement.length)&&(start=mediaElement.start(0),mediaElement=mediaElement.end(0),isValidDuration(start)||(start=0),0<(mediaElement=isValidDuration(mediaElement)?mediaElement:0)-start)},BaseHtmlPlayer.prototype.setCurrentSrcChromecast=function(elem,options,url,hasHlsTextTracks,tracksHtml){elem.autoplay=!0;elem=new cast.framework.messages.LoadRequestData,elem.currentTime=(options.playerStartPositionTicks||0)/1e7,elem.autoplay=!0,elem.media=new cast.framework.messages.MediaInformation,elem.media.contentId=url,elem.media.contentUrl=url,elem.media.contentType=options.mimeType,"application/x-mpegurl"===(options.mimeType||"").toLowerCase()||"application/vnd.apple.mpegurl"===(options.mimeType||"").toLowerCase()?elem.media.streamType=cast.framework.messages.StreamType.OTHER:elem.media.streamType=cast.framework.messages.StreamType.BUFFERED,elem.media.customData={options:options,hasHlsTextTracks:hasHlsTextTracks,tracksHtml:tracksHtml},url=options.item,hasHlsTextTracks=!0;return"Audio"===url.MediaType?(elem.media.metadata=new cast.framework.messages.MusicTrackMediaMetadata,elem.media.mediaCategory=cast.framework.messages.MediaCategory.AUDIO,url.Album&&(elem.media.metadata.albumName=url.Album),null!=url.IndexNumber&&(elem.media.metadata.trackNumber=url.IndexNumber),null!=url.ParentIndexNumber&&(elem.media.metadata.discNumber=url.ParentIndexNumber),url.AlbumArtists&&url.AlbumArtists.length&&(elem.media.metadata.albumArtist=url.AlbumArtists[0].Name),url.ArtistItems&&url.ArtistItems.length&&(elem.media.metadata.artist=url.ArtistItems[0].Name),elem.media.metadata.songTitle=url.Name):"Photo"===url.MediaType?(elem.media.metadata=new cast.framework.messages.PhotoMediaMetadata,elem.media.mediaCategory=cast.framework.messages.MediaCategory.IMAGE,hasHlsTextTracks=!1):"Episode"===url.Type?(elem.media.metadata=new cast.framework.messages.TvShowMediaMetadata,elem.media.mediaCategory=cast.framework.messages.MediaCategory.VIDEO,url.SeriesName&&(elem.media.metadata.seriesTitle=url.SeriesName),null!=url.IndexNumber&&(elem.media.metadata.episode=url.IndexNumber),null!=url.ParentIndexNumber&&(elem.media.metadata.season=url.ParentIndexNumber)):("Movie"===url.Type||"Trailer"===url.Type?elem.media.metadata=new cast.framework.messages.MovieMediaMetadata:elem.media.metadata=new cast.framework.messages.GenericMediaMetadata,elem.media.mediaCategory=cast.framework.messages.MediaCategory.VIDEO),url.OfficialRating&&(elem.media.metadata.contentRating=url.OfficialRating),elem.media.metadata.title=url.Name,url.Studios&&url.Studios.length&&(elem.media.metadata.studio=url.Studios[0].Name),elem.media.userActionStates=[cast.framework.messages.UserActionState.LIKE,cast.framework.messages.UserActionState.DISLIKE],hasHlsTextTracks&&(tracksHtml=[],(options=getPosterUrl(url))&&(elem.media.metadata.posterUrl=options,tracksHtml.push(new cast.framework.messages.Image(elem.media.metadata.posterUrl))),elem.media.metadata.images=tracksHtml),console.log("loading media url into mediaManager"),cast.framework.CastReceiverContext.getInstance().getPlayerManager().load(elem)},BaseHtmlPlayer.prototype.setSrcWithHlsJs=function(elem,options,url){var instance=this;return Emby.importModule("./modules/hlsjs/hls.js").then(function(hls){return window.Hls=hls}).then(function(Hls){var hlsOptions={manifestLoadingTimeOut:2e4,debug:!1,testBandwidth:!1,emeEnabled:!1},hls=("Audio"!==options.mediaType||_browser.default.chromecast||(hlsOptions.maxMaxBufferLength=120),new Hls(hlsOptions));return hls.subtitleDisplay=!1,hls.loadSource(url),hls.attachMedia(elem),new Promise(function(resolve,reject){bindEventsToHlsPlayer(instance,hls,elem,resolve,reject),instance._hlsPlayer=hls,instance._currentSrc=url})})},BaseHtmlPlayer.prototype.seekOnPlaybackStart=function(element,ticks){ticks=(ticks||0)/1e7;ticks&&(setCurrentTimeIfNeeded(element,ticks,5),5<=Math.abs((element.currentTime||0)-ticks))&&!function(element,seconds,allowance){setTimeout(function(){setCurrentTimeIfNeeded(element,seconds,allowance)},2500)}(element,ticks,10)},BaseHtmlPlayer.prototype.bindMediaManagerEvents=function(){cast.framework.CastReceiverContext.getInstance().getPlayerManager().setMessageInterceptor(cast.framework.messages.MessageType.LOAD,function(data){var media=data.media,customData=media.customData,val=media.contentId,options=customData.options,elem=this._mediaElement;return this.loadIntoPlayer(elem,options,val,media,data,customData).then(function(){return data})}.bind(this))},BaseHtmlPlayer.prototype.unBindMediaManagerEvents=function(){cast.framework.CastReceiverContext.getInstance().getPlayerManager().setMessageInterceptor(cast.framework.messages.MessageType.LOAD,null)},BaseHtmlPlayer.prototype.getCrossOriginValue=function(mediaSource,playMethod){return mediaSource.IsRemote&&"DirectPlay"===playMethod?null:"anonymous"},BaseHtmlPlayer.prototype.onEnded=function(elem,triggerStopEvent){this.removeErrorEventListener(elem),elem.src="",elem.innerHTML="",elem.removeAttribute("src"),"undefined"!=typeof cast&&null!=(elem=cast.framework)&&elem.CastReceiverContext&&cast.framework.CastReceiverContext.getInstance().getPlayerManager().stop(),this.destroyHlsPlayer(),this.destroyCastPlayer();elem=this._currentSrc;!1!==(triggerStopEvent=elem?triggerStopEvent:!1)&&_events.default.trigger(this,"stopped",[{src:elem}]),this._currentTime=null,this._currentSrc=null,this._currentPlayOptions=null},BaseHtmlPlayer.prototype.addEventListeners=function(elem){this.removeEventListeners(elem),elem.addEventListener("volumechange",this.boundOnVolumeChange),elem.addEventListener("ratechange",this.boundOnRateChange),elem.addEventListener("waiting",this.boundOnWaiting),elem.addEventListener("play",this.boundOnPlay),elem.addEventListener("pause",this.boundOnPause),elem.addEventListener("ended",this.boundOnEnded),elem.addEventListener("timeupdate",this.boundOnTimeUpdate),elem.addEventListener("seeked",this.boundOnTimeUpdate),elem.addEventListener("playing",this.boundOnPlaying)},BaseHtmlPlayer.prototype.removeErrorEventListener=function(elem){elem.removeEventListener("error",this.boundOnError)},BaseHtmlPlayer.prototype.removeEventListeners=function(elem){elem.removeEventListener("volumechange",this.boundOnVolumeChange),elem.removeEventListener("ratechange",this.boundOnRateChange),elem.removeEventListener("waiting",this.boundOnWaiting),elem.removeEventListener("play",this.boundOnPlay),elem.removeEventListener("pause",this.boundOnPause),elem.removeEventListener("ended",this.boundOnEnded),elem.removeEventListener("timeupdate",this.boundOnTimeUpdate),elem.removeEventListener("seeked",this.boundOnTimeUpdate),elem.removeEventListener("playing",this.boundOnPlaying)},BaseHtmlPlayer.prototype.destroyCastPlayer=function(){var player=this._castPlayer;if(player){try{player.unload()}catch(err){console.log(err)}this._castPlayer=null}},BaseHtmlPlayer.prototype.destroyHlsPlayer=function(){var player=this._hlsPlayer;if(player){try{console.log("destroying hls player"),player.destroy()}catch(err){console.log(err)}this._hlsPlayer=null}},BaseHtmlPlayer.prototype.onError=function(errorType){_events.default.trigger(this,"error",[{type:errorType}])},BaseHtmlPlayer.prototype.playWithPromise=function(elem){var instance=this;try{var promise=elem.play();return promise&&promise.then?promise.then(function(e){return Promise.resolve({autoplayed:!0})}.bind(elem),function(e){e=(e.name||"").toLowerCase();return"notallowederror"===(e="notsupportederror"===e?"medianotsupported":e)||"aborterror"===e?(onSuccessfulPlay(instance,elem),Promise.resolve({autoplayed:!1})):Promise.reject({name:e||"notallowederror"})}):(onSuccessfulPlay(instance,elem),Promise.resolve({autoplayed:_browser.default.tv||_browser.default.chromecast}))}catch(err){return console.log("error calling video.play: "+err),Promise.reject()}},BaseHtmlPlayer.prototype.onTimeUpdate=function(elem,time,isFirstTimeUpdate){},BaseHtmlPlayer.prototype.onStartedPlaying=function(elem){this.seekOnPlaybackStart(elem,this._currentPlayOptions.playerStartPositionTicks)};_exports.default=BaseHtmlPlayer});