import { IrcServer } from "../irc/IrcServer";
export declare class QuitDebouncer {
    private handleQuit;
    private debouncerForServer;
    private wasSplitOccuring;
    constructor(servers: IrcServer[], handleQuit: (channel: string, server: IrcServer, nicks: string[]) => Promise<void>);
    /**
     * Called when the IrcHandler receives a JOIN. This resolves any promises to join that were made
     * when a quit was debounced during a split.
     * @param {string} nick The nick of the IRC user joining.
     * @param {IrcServer} server The sending IRC server.
     * @returns True if the join should be processed, otherwise false.
     */
    onJoin(nick: string, channel: string, server: IrcServer): boolean;
    /**
     * Get a list of nicknames that have been QUIT from a channel.
     * @param channel The IRC channel
     * @param server The IRC server
     */
    private getQuitNicksForChannel;
    /**
     * Debounce a QUIT received by the IrcHandler to prevent net-splits from spamming leave events
     * into a room when incremental membership syncing is enabled.
     * @param {Request} req The metadata request.
     * @param {IrcServer} server The sending IRC server.
     * @param {string} matrixUser The virtual user of the user that sent QUIT.
     * @param {string} nick The nick of the IRC user quiting.
     * @return {Promise} which resolves to true if a leave should be sent, false otherwise.
     */
    debounceQuit(nick: string, server: IrcServer, channels: string[]): boolean;
}
