#ifndef MESHREFINER_HPP
#define MESHREFINER_HPP
//!\file
//!\brief Function object which refines meshes.

#include "unstructured/MeshLevel.hpp"

namespace mgard {

//! Function object that refines meshes.
class MeshRefiner {
public:
  //! Refine a mesh.
  //!
  //!\param mesh Mesh to be refined.
  //!
  //!\return Mesh obtained by refining the input mesh.
  MeshLevel operator()(const MeshLevel &mesh);

private:
  //! Refine a mesh.
  //!
  //!\param mesh Mesh to be refined.
  //!
  //!\return Mesh obtained by refining the input mesh.
  virtual MeshLevel do_operator_parentheses(const MeshLevel &mesh) = 0;
};

} // namespace mgard

#endif
