/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import org.apache.lucene.spatial3d.geom.GeoCircle;
import org.apache.lucene.spatial3d.geom.GeoDegeneratePoint;
import org.apache.lucene.spatial3d.geom.GeoExactCircle;
import org.apache.lucene.spatial3d.geom.GeoStandardCircle;
import org.apache.lucene.spatial3d.geom.PlanetModel;

public class GeoCircleFactory {
    private GeoCircleFactory() {
    }

    public static GeoCircle makeGeoCircle(PlanetModel planetModel, double latitude, double longitude, double cutoffAngle) {
        if (cutoffAngle < 3.141592653589793E-12) {
            return new GeoDegeneratePoint(planetModel, latitude, longitude);
        }
        return new GeoStandardCircle(planetModel, latitude, longitude, cutoffAngle);
    }

    public static GeoCircle makeExactGeoCircle(PlanetModel planetModel, double latitude, double longitude, double radius, double accuracy) {
        if (radius < 3.141592653589793E-12) {
            return new GeoDegeneratePoint(planetModel, latitude, longitude);
        }
        return new GeoExactCircle(planetModel, latitude, longitude, radius, accuracy);
    }
}

