/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.NativeServices;
import org.bouncycastle.crypto.OutputMACCalculator;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.FipsDH;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.fips.FipsDSA;
import org.bouncycastle.crypto.fips.FipsEC;
import org.bouncycastle.crypto.fips.FipsEdEC;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsPBKD;
import org.bouncycastle.crypto.fips.FipsRSA;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsTripleDES;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class DumpInfo {
    private static final String[] classes = new String[]{FipsAES.class.getName(), FipsTripleDES.class.getName(), FipsDH.class.getName(), FipsSHS.class.getName(), FipsDRBG.class.getName(), FipsDSA.class.getName(), FipsEdEC.class.getName(), FipsEC.class.getName(), FipsKDF.class.getName(), FipsPBKD.class.getName(), FipsRSA.class.getName()};

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            if (stringArray[0].equals("-verbose")) {
                System.out.print(DumpInfo.buildInfoString(true));
            } else if (stringArray[0].equals("-c")) {
                System.out.println(Strings.fromByteArray(Hex.encode(FipsStatus.getModuleHMAC())));
                System.err.println("Generated new HMAC");
            } else if (stringArray[0].equals("-a") && stringArray.length > 1) {
                try {
                    JarFile jarFile = new JarFile(stringArray[1]);
                    System.out.println(Strings.fromByteArray(Hex.encode(DumpInfo.calculateModuleHMAC(jarFile))));
                    System.err.println("Generated new HMAC for Jar file " + stringArray[1]);
                }
                catch (IOException iOException) {
                    System.err.println("Unable to open Jar file " + stringArray[1]);
                }
            } else {
                System.err.println("Invalid command line arguments.");
            }
        } else {
            System.out.print(DumpInfo.buildInfoString(false));
        }
    }

    public static String getInfoString(boolean bl) {
        return DumpInfo.buildInfoString(bl);
    }

    private static String buildInfoString(boolean bl) {
        String[][] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.lineSeparator();
        DumpInfo.runTests();
        stringBuilder.append("Version Info: ");
        stringBuilder.append(BouncyCastleFipsProvider.getInfoString());
        stringBuilder.append(string);
        stringBuilder.append("FIPS Ready Status: ");
        stringBuilder.append(FipsStatus.getStatusMessage());
        stringBuilder.append(string);
        NativeServices nativeServices = CryptoServicesRegistrar.getNativeServices();
        if (bl || nativeServices.isEnabled()) {
            if (bl || nativeServices.isSupported()) {
                stringBuilder.append("Native Ready Status: ");
                stringBuilder.append(nativeServices.getStatusMessage());
                stringBuilder.append(string);
                stringBuilder.append("Native Variant: ");
                stringBuilder.append(nativeServices.getVariant());
                stringBuilder.append(string);
                stringBuilder.append("Native Build Date: ");
                stringBuilder.append(nativeServices.getBuildDate());
                stringBuilder.append(string);
            }
            if (nativeServices.isEnabled()) {
                stringBuilder.append("Native Support: ");
                stringBuilder.append(DumpInfo.getNativeFeatureString(nativeServices));
                stringBuilder.append(string);
            }
        }
        if (bl) {
            stringBuilder.append(DumpInfo.getVerboseStatusMessage(nativeServices));
        }
        if (bl && (stringArray = nativeServices.getVariantSelectionMatrix()).length > 0) {
            stringBuilder.append(string);
            stringBuilder.append("CPU Features and Variant availability.");
            stringBuilder.append(string);
            stringBuilder.append("--------------------------------------------------------------------------------");
            stringBuilder.append(string);
            stringBuilder.append(DumpInfo.pad("Variant", 10));
            stringBuilder.append(DumpInfo.pad("CPU features + or -:", 50));
            stringBuilder.append(DumpInfo.pad("Supported", 20));
            stringBuilder.append(string);
            stringBuilder.append("--------------------------------------------------------------------------------");
            stringBuilder.append(string);
            for (String[] stringArray2 : stringArray) {
                String string2 = DumpInfo.pad(stringArray2[0], 10);
                String string3 = "";
                for (int i = 1; i < stringArray2.length - 1; ++i) {
                    string3 = string3 + stringArray2[i];
                    string3 = string3 + " ";
                }
                string3 = DumpInfo.pad(string3.trim(), 50);
                String string4 = stringArray2[stringArray2.length - 1];
                stringBuilder.append(string2);
                stringBuilder.append(string3);
                stringBuilder.append(string4);
                stringBuilder.append(string);
            }
            stringBuilder.append(string);
        }
        stringBuilder.append("Module SHA-256 HMAC: " + Strings.fromByteArray(Hex.encode(FipsStatus.getModuleHMAC())));
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static String getVerboseStatusMessage(NativeServices nativeServices) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Native Libs Available: " + nativeServices.isSupported());
        printWriter.println("Native Libs Installed: " + nativeServices.isInstalled());
        printWriter.println("Native Status Message: " + nativeServices.getStatusMessage());
        printWriter.close();
        return stringWriter.toString();
    }

    private static String getNativeFeatureString(NativeServices nativeServices) {
        return String.join((CharSequence)" ", nativeServices.getFeatureSet());
    }

    private static String pad(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private static byte[] calculateModuleHMAC(JarFile jarFile) {
        try {
            Object object;
            OutputMACCalculator outputMACCalculator = new FipsSHS.MACOperatorFactory().createOutputMACCalculator((SymmetricKey)new SymmetricSecretKey(FipsSHS.Algorithm.SHA256_HMAC, Strings.toByteArray("Legion of the Bouncy Castle Inc.")), FipsSHS.SHA256_HMAC);
            UpdateOutputStream updateOutputStream = outputMACCalculator.getMACStream();
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            Object object2 = jarFile.entries();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                if (DumpInfo.skipEntry((JarEntry)object)) continue;
                treeMap.put(((ZipEntry)object).getName(), object);
            }
            object2 = new byte[8192];
            for (Map.Entry entry : treeMap.entrySet()) {
                int n;
                JarEntry jarEntry = (JarEntry)entry.getValue();
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                byte[] byArray = Strings.toUTF8ByteArray(jarEntry.getName());
                updateOutputStream.update((byte)91);
                updateOutputStream.update(byArray, 0, byArray.length);
                updateOutputStream.update(Pack.longToBigEndian(jarEntry.getSize()), 0, 8);
                updateOutputStream.update((byte)93);
                while ((n = inputStream.read((byte[])object2, 0, ((Object)object2).length)) != -1) {
                    updateOutputStream.update((byte[])object2, 0, n);
                }
                inputStream.close();
            }
            updateOutputStream.update((byte)91);
            object = Strings.toUTF8ByteArray("END");
            updateOutputStream.update((byte[])object, 0, ((Object)object).length);
            updateOutputStream.update((byte)93);
            updateOutputStream.close();
            return outputMACCalculator.getMAC();
        }
        catch (Exception exception) {
            return new byte[32];
        }
    }

    private static boolean skipEntry(JarEntry jarEntry) {
        if (jarEntry.isDirectory() || jarEntry.getName().indexOf("module-info.class") > 0) {
            return true;
        }
        if (jarEntry.getName().startsWith("META-INF/")) {
            if (jarEntry.getName().contains("OSGI-INF/")) {
                return true;
            }
            if (jarEntry.getName().indexOf("versions/") < 0) {
                return true;
            }
        }
        return false;
    }

    private static void runTests() {
        for (String object : classes) {
            if (FipsStatus.isErrorStatus()) continue;
            DumpInfo.loadClass(object);
        }
        NativeServices nativeServices = CryptoServicesRegistrar.getNativeServices();
        if (nativeServices.isEnabled() && nativeServices.isSupported()) {
            SymmetricSecretKey symmetricSecretKey = new SymmetricSecretKey(FipsAES.ALGORITHM, Hex.decode("000102030405060708090a0b0c0d0e0f"));
            FipsAES.OperatorFactory operatorFactory = new FipsAES.OperatorFactory();
            if (nativeServices.hasService("AES/ECB")) {
                operatorFactory.createOutputEncryptor((SymmetricKey)symmetricSecretKey, FipsAES.ECB);
            }
            if (nativeServices.hasService("AES/CBC")) {
                operatorFactory.createOutputEncryptor((SymmetricKey)symmetricSecretKey, FipsAES.CBC.withIV(Hex.decode("000102030405060708090a0b0c0d0e0f")));
            }
            if (nativeServices.hasService("AES/CFB")) {
                operatorFactory.createOutputEncryptor((SymmetricKey)symmetricSecretKey, FipsAES.CFB128.withIV(Hex.decode("000102030405060708090a0b0c0d0e0f")));
            }
            if (nativeServices.hasService("AES/CTR")) {
                operatorFactory.createOutputEncryptor((SymmetricKey)symmetricSecretKey, FipsAES.CTR.withIV(Hex.decode("000102030405060708090a0b0c0d0e0f")));
            }
            FipsAES.AEADOperatorFactory aEADOperatorFactory = new FipsAES.AEADOperatorFactory();
            if (nativeServices.hasService("AES/GCM")) {
                aEADOperatorFactory.createOutputAEADEncryptor((SymmetricKey)symmetricSecretKey, FipsAES.GCM.withIV(Hex.decode("000102030405060708090a0b")));
            }
            if (nativeServices.hasService("SHA2")) {
                new FipsSHS.OperatorFactory<FipsSHS.Parameters>().createOutputDigestCalculator(FipsSHS.SHA256);
            }
            if (nativeServices.hasService("DRBG") || nativeServices.hasService("NRBG")) {
                CryptoServicesRegistrar.getDefaultEntropySourceProvider().get(256);
            }
        }
    }

    private static void loadClass(String string) {
        try {
            Class.forName(string);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw exceptionInInitializerError;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Unable to initialize module: " + classNotFoundException.getMessage(), classNotFoundException);
        }
    }
}

