/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.streamingingestion.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.pagination.PageParams;
import org.opensearch.action.support.broadcast.BroadcastRequest;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

@ExperimentalApi
public class GetIngestionStateRequest
extends BroadcastRequest<GetIngestionStateRequest> {
    public static final int DEFAULT_PAGE_SIZE = 1000;
    public static final String DEFAULT_SORT_VALUE = "asc";
    private int[] shards;
    private PageParams pageParams;
    private List<IndexShardPair> indexShardPairsList;

    public GetIngestionStateRequest(String[] indices) {
        super(new String[0]);
        this.indices = indices;
        this.shards = new int[0];
        this.pageParams = new PageParams(null, DEFAULT_SORT_VALUE, 1000);
        this.indexShardPairsList = new ArrayList<IndexShardPair>();
    }

    public GetIngestionStateRequest(StreamInput in) throws IOException {
        super(in);
        this.shards = in.readVIntArray();
        this.pageParams = (PageParams)in.readOptionalWriteable(PageParams::new);
        this.indexShardPairsList = in.readList(x$0 -> new IndexShardPair(this, x$0));
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        } else if (this.indices.length != Arrays.stream(this.indices).collect(Collectors.toSet()).size()) {
            validationException = ValidateActions.addValidationError("duplicate index names provided", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVIntArray(this.shards);
        out.writeOptionalWriteable((Writeable)this.pageParams);
        out.writeList(this.indexShardPairsList);
    }

    public int[] getShards() {
        return this.shards;
    }

    public void setShards(int[] shards) {
        this.shards = shards;
    }

    public PageParams getPageParams() {
        return this.pageParams;
    }

    public void setPageParams(PageParams pageParams) {
        this.pageParams = pageParams;
    }

    public void addIndexShardPair(String indexName, int shard) {
        this.indexShardPairsList.add(new IndexShardPair(this, indexName, shard));
    }

    public Map<String, Set<Integer>> getIndexShardPairsAsMap() {
        HashMap<String, Set<Integer>> indexShardMap = new HashMap<String, Set<Integer>>();
        for (IndexShardPair indexShardPair : this.indexShardPairsList) {
            indexShardMap.computeIfAbsent(indexShardPair.indexName, indexName -> new HashSet()).add(indexShardPair.shard);
        }
        return indexShardMap;
    }

    private class IndexShardPair
    implements Writeable {
        String indexName;
        int shard;

        public IndexShardPair(GetIngestionStateRequest getIngestionStateRequest, StreamInput in) throws IOException {
            this.indexName = in.readString();
            this.shard = in.readVInt();
        }

        public IndexShardPair(GetIngestionStateRequest getIngestionStateRequest, String indexName, int shard) {
            this.indexName = indexName;
            this.shard = shard;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.indexName);
            out.writeVInt(this.shard);
        }
    }
}

