/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.upgrade.post;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.Version;
import org.opensearch.action.PrimaryMissingActionException;
import org.opensearch.action.admin.indices.upgrade.post.ShardUpgradeResult;
import org.opensearch.action.admin.indices.upgrade.post.UpgradeRequest;
import org.opensearch.action.admin.indices.upgrade.post.UpgradeResponse;
import org.opensearch.action.admin.indices.upgrade.post.UpgradeSettingsAction;
import org.opensearch.action.admin.indices.upgrade.post.UpgradeSettingsRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.node.NodeClient;

public class TransportUpgradeAction
extends TransportBroadcastByNodeAction<UpgradeRequest, UpgradeResponse, ShardUpgradeResult> {
    private final IndicesService indicesService;
    private final NodeClient client;

    @Inject
    public TransportUpgradeAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeClient client) {
        super("indices:admin/upgrade", clusterService, transportService, actionFilters, indexNameExpressionResolver, UpgradeRequest::new, "force_merge");
        this.indicesService = indicesService;
        this.client = client;
    }

    @Override
    protected UpgradeResponse newResponse(UpgradeRequest request, int totalShards, int successfulShards, int failedShards, List<ShardUpgradeResult> shardUpgradeResults, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        HashMap<String, Integer> successfulPrimaryShards = new HashMap<String, Integer>();
        HashMap<String, Tuple> versions = new HashMap<String, Tuple>();
        for (ShardUpgradeResult result : shardUpgradeResults) {
            Tuple versionTuple;
            ++successfulShards;
            String index = result.getShardId().getIndex().getName();
            if (result.primary()) {
                Integer count = (Integer)successfulPrimaryShards.get(index);
                successfulPrimaryShards.put(index, count == null ? 1 : count + 1);
            }
            if ((versionTuple = (Tuple)versions.get(index)) == null) {
                versions.put(index, new Tuple((Object)result.upgradeVersion(), (Object)result.oldestLuceneSegment()));
                continue;
            }
            Version version = (Version)versionTuple.v1();
            org.apache.lucene.util.Version luceneVersion = (org.apache.lucene.util.Version)versionTuple.v2();
            if (result.upgradeVersion().after((Version)versionTuple.v1())) {
                version = result.upgradeVersion();
            }
            if (!result.oldestLuceneSegment().onOrAfter((org.apache.lucene.util.Version)versionTuple.v2())) {
                luceneVersion = result.oldestLuceneSegment();
            }
            versions.put(index, new Tuple((Object)version, (Object)luceneVersion));
        }
        HashMap<String, Tuple<Version, String>> updatedVersions = new HashMap<String, Tuple<Version, String>>();
        Metadata metadata = clusterState.metadata();
        for (Map.Entry versionEntry : versions.entrySet()) {
            String index = (String)versionEntry.getKey();
            Integer primaryCount = (Integer)successfulPrimaryShards.get(index);
            int expectedPrimaryCount = metadata.index(index).getNumberOfShards();
            if (primaryCount.intValue() == metadata.index(index).getNumberOfShards()) {
                updatedVersions.put(index, (Tuple<Version, String>)new Tuple((Object)((Version)((Tuple)versionEntry.getValue()).v1()), (Object)((org.apache.lucene.util.Version)((Tuple)versionEntry.getValue()).v2()).toString()));
                continue;
            }
            this.logger.warn("Not updating settings for the index [{}] because upgraded of some primary shards failed - expected[{}], received[{}]", (Object)index, (Object)expectedPrimaryCount, (Object)(primaryCount == null ? 0 : primaryCount));
        }
        return new UpgradeResponse(updatedVersions, totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected ShardUpgradeResult shardOperation(UpgradeRequest request, ShardRouting shardRouting) throws IOException {
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex()).getShard(shardRouting.shardId().id());
        org.apache.lucene.util.Version oldestLuceneSegment = indexShard.upgrade(request);
        return new ShardUpgradeResult(shardRouting.shardId(), indexShard.routingEntry().primary(), Version.CURRENT, oldestLuceneSegment);
    }

    @Override
    protected ShardUpgradeResult readShardResult(StreamInput in) throws IOException {
        return new ShardUpgradeResult(in);
    }

    @Override
    protected UpgradeRequest readRequestFrom(StreamInput in) throws IOException {
        return new UpgradeRequest(in);
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, UpgradeRequest request, String[] concreteIndices) {
        ShardsIterator iterator = clusterState.routingTable().allShards(concreteIndices);
        Set<String> indicesWithMissingPrimaries = this.indicesWithMissingPrimaries(clusterState, concreteIndices);
        if (indicesWithMissingPrimaries.isEmpty()) {
            return iterator;
        }
        throw new PrimaryMissingActionException("Cannot upgrade indices because the following indices are missing primary shards " + String.valueOf(indicesWithMissingPrimaries));
    }

    private Set<String> indicesWithMissingPrimaries(ClusterState clusterState, String[] concreteIndices) {
        HashSet<String> indices = new HashSet<String>();
        RoutingTable routingTable = clusterState.routingTable();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRoutingTable = routingTable.index(index);
            if (indexRoutingTable.allPrimaryShardsActive()) continue;
            indices.add(index);
        }
        return indices;
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, UpgradeRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, UpgradeRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }

    @Override
    protected void doExecute(Task task, UpgradeRequest request, ActionListener<UpgradeResponse> listener) {
        super.doExecute(task, request, ActionListener.wrap(upgradeResponse -> {
            if (upgradeResponse.versions().isEmpty()) {
                listener.onResponse((Object)upgradeResponse);
            } else {
                this.updateSettings((UpgradeResponse)((Object)upgradeResponse), listener);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void updateSettings(UpgradeResponse upgradeResponse, ActionListener<UpgradeResponse> listener) {
        UpgradeSettingsRequest upgradeSettingsRequest = new UpgradeSettingsRequest(upgradeResponse.versions());
        this.client.executeLocally(UpgradeSettingsAction.INSTANCE, upgradeSettingsRequest, ActionListener.delegateFailure(listener, (delegatedListener, updateSettingsResponse) -> delegatedListener.onResponse((Object)upgradeResponse)));
    }
}

