/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.action.search.SearchPhaseName;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.annotation.PublicApi;

@PublicApi(since="1.0.0")
public abstract class SearchPhase
implements CheckedRunnable<IOException> {
    private final String name;
    private long startTimeInNanos;

    protected SearchPhase(String name) {
        this.name = Objects.requireNonNull(name, "name must not be null");
    }

    public long getStartTimeInNanos() {
        return this.startTimeInNanos;
    }

    public void recordAndRun() throws IOException {
        this.startTimeInNanos = System.nanoTime();
        this.run();
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public SearchPhaseName getSearchPhaseName() {
        return SearchPhaseName.valueOf(this.name.toUpperCase(Locale.ROOT));
    }

    public Optional<SearchPhaseName> getSearchPhaseNameOptional() {
        try {
            return Optional.of(SearchPhaseName.valueOf(this.name.toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }
}

