/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata.plain;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Accountable;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.index.fielddata.LeafOrdinalsFieldData;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;

public abstract class AbstractLeafOrdinalsFieldData
implements LeafOrdinalsFieldData {
    public static final Function<SortedSetDocValues, ScriptDocValues<?>> DEFAULT_SCRIPT_FUNCTION = ((Function<SortedSetDocValues, SortedBinaryDocValues>)FieldData::toString).andThen(ScriptDocValues.Strings::new);
    private final Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction;

    protected AbstractLeafOrdinalsFieldData(Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction) {
        this.scriptFunction = scriptFunction;
    }

    @Override
    public final ScriptDocValues<?> getScriptValues() {
        return this.scriptFunction.apply(this.getOrdinalsValues());
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getOrdinalsValues());
    }

    public static LeafOrdinalsFieldData empty() {
        return new AbstractLeafOrdinalsFieldData((Function)DEFAULT_SCRIPT_FUNCTION){

            public long ramBytesUsed() {
                return 0L;
            }

            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }

            public void close() {
            }

            @Override
            public SortedSetDocValues getOrdinalsValues() {
                return DocValues.emptySortedSet();
            }
        };
    }
}

