/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.mapper;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MetadataFieldMapper;

@PublicApi(since="1.0.0")
public final class MapperRegistry {
    private final Map<String, Mapper.TypeParser> mapperParsers;
    private final Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers;
    private final Function<String, Predicate<String>> fieldFilter;

    public MapperRegistry(Map<String, Mapper.TypeParser> mapperParsers, Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers, Function<String, Predicate<String>> fieldFilter) {
        this.mapperParsers = Collections.unmodifiableMap(new LinkedHashMap<String, Mapper.TypeParser>(mapperParsers));
        this.metadataMapperParsers = Collections.unmodifiableMap(new LinkedHashMap<String, MetadataFieldMapper.TypeParser>(metadataMapperParsers));
        this.fieldFilter = fieldFilter;
    }

    public Map<String, Mapper.TypeParser> getMapperParsers() {
        return this.mapperParsers;
    }

    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMapperParsers() {
        return this.metadataMapperParsers;
    }

    public boolean isMetadataField(String field) {
        return this.getMetadataMapperParsers().containsKey(field);
    }

    public Function<String, Predicate<String>> getFieldFilter() {
        return this.fieldFilter;
    }
}

