/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import java.io.IOException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.store.Store;
import org.opensearch.indices.recovery.RecoveryTransportRequest;

public class RecoveryCleanFilesRequest
extends RecoveryTransportRequest {
    private final long recoveryId;
    private final ShardId shardId;
    private final Store.MetadataSnapshot snapshotFiles;
    private final int totalTranslogOps;
    private final long globalCheckpoint;

    public RecoveryCleanFilesRequest(long recoveryId, long requestSeqNo, ShardId shardId, Store.MetadataSnapshot snapshotFiles, int totalTranslogOps, long globalCheckpoint) {
        super(requestSeqNo);
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.snapshotFiles = snapshotFiles;
        this.totalTranslogOps = totalTranslogOps;
        this.globalCheckpoint = globalCheckpoint;
    }

    RecoveryCleanFilesRequest(StreamInput in) throws IOException {
        super(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        this.snapshotFiles = new Store.MetadataSnapshot(in);
        this.totalTranslogOps = in.readVInt();
        this.globalCheckpoint = in.readZLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        this.snapshotFiles.writeTo(out);
        out.writeVInt(this.totalTranslogOps);
        out.writeZLong(this.globalCheckpoint);
    }

    public Store.MetadataSnapshot sourceMetaSnapshot() {
        return this.snapshotFiles;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public int totalTranslogOps() {
        return this.totalTranslogOps;
    }

    public long getGlobalCheckpoint() {
        return this.globalCheckpoint;
    }
}

