/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.checkpoint;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.support.replication.ReplicationRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.indices.replication.checkpoint.MergedSegmentCheckpoint;

public class PublishMergedSegmentRequest
extends ReplicationRequest<PublishMergedSegmentRequest> {
    private final MergedSegmentCheckpoint mergedSegment;

    public PublishMergedSegmentRequest(MergedSegmentCheckpoint mergedSegment) {
        super(mergedSegment.getShardId());
        this.mergedSegment = mergedSegment;
    }

    public PublishMergedSegmentRequest(StreamInput in) throws IOException {
        super(in);
        this.mergedSegment = new MergedSegmentCheckpoint(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.mergedSegment.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishMergedSegmentRequest)) {
            return false;
        }
        PublishMergedSegmentRequest that = (PublishMergedSegmentRequest)o;
        return Objects.equals(this.mergedSegment, that.mergedSegment);
    }

    public int hashCode() {
        return Objects.hash(this.mergedSegment);
    }

    @Override
    public String toString() {
        return "PublishMergedSegmentRequest{mergedSegment=" + String.valueOf(this.mergedSegment) + "}";
    }

    public MergedSegmentCheckpoint getMergedSegment() {
        return this.mergedSegment;
    }
}

