/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensearch.Version;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.search.profile.NetworkTime;
import org.opensearch.search.profile.aggregation.AggregationProfileShardResult;
import org.opensearch.search.profile.fetch.FetchProfileShardResult;
import org.opensearch.search.profile.query.QueryProfileShardResult;

@PublicApi(since="1.0.0")
public class ProfileShardResult
implements Writeable {
    private final List<QueryProfileShardResult> queryProfileResults;
    private final AggregationProfileShardResult aggProfileShardResult;
    private final FetchProfileShardResult fetchProfileResult;
    private NetworkTime networkTime;

    public ProfileShardResult(List<QueryProfileShardResult> queryProfileResults, AggregationProfileShardResult aggProfileShardResult, FetchProfileShardResult fetchProfileResult, NetworkTime networkTime) {
        this.aggProfileShardResult = aggProfileShardResult;
        this.fetchProfileResult = fetchProfileResult;
        this.queryProfileResults = Collections.unmodifiableList(queryProfileResults);
        this.networkTime = networkTime;
    }

    @Deprecated
    public ProfileShardResult(List<QueryProfileShardResult> queryProfileResults, AggregationProfileShardResult aggProfileShardResult, NetworkTime networkTime) {
        this(queryProfileResults, aggProfileShardResult, new FetchProfileShardResult(Collections.emptyList()), networkTime);
    }

    public ProfileShardResult(StreamInput in) throws IOException {
        int profileSize = in.readVInt();
        ArrayList<QueryProfileShardResult> queryProfileResults = new ArrayList<QueryProfileShardResult>(profileSize);
        for (int i = 0; i < profileSize; ++i) {
            QueryProfileShardResult result = new QueryProfileShardResult(in);
            queryProfileResults.add(result);
        }
        this.queryProfileResults = Collections.unmodifiableList(queryProfileResults);
        this.aggProfileShardResult = new AggregationProfileShardResult(in);
        this.fetchProfileResult = in.getVersion().onOrAfter(Version.V_3_2_0) ? new FetchProfileShardResult(in) : new FetchProfileShardResult(Collections.emptyList());
        this.networkTime = new NetworkTime(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.queryProfileResults.size());
        for (QueryProfileShardResult queryShardResult : this.queryProfileResults) {
            queryShardResult.writeTo(out);
        }
        this.aggProfileShardResult.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_3_2_0)) {
            this.fetchProfileResult.writeTo(out);
        }
        this.networkTime.writeTo(out);
    }

    public List<QueryProfileShardResult> getQueryProfileResults() {
        return this.queryProfileResults;
    }

    public AggregationProfileShardResult getAggregationProfileResults() {
        return this.aggProfileShardResult;
    }

    public FetchProfileShardResult getFetchProfileResult() {
        return this.fetchProfileResult;
    }

    public NetworkTime getNetworkTime() {
        return this.networkTime;
    }

    public void setNetworkTime(NetworkTime newTime) {
        this.networkTime.setInboundNetworkTime(newTime.getInboundNetworkTime());
        this.networkTime.setOutboundNetworkTime(newTime.getOutboundNetworkTime());
    }
}

