/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.opensearch.OpenSearchException;
import org.opensearch.search.profile.AbstractProfileBreakdown;
import org.opensearch.search.profile.ContextualProfileBreakdown;
import org.opensearch.search.profile.ProfileMetric;
import org.opensearch.search.profile.Timer;
import org.opensearch.search.profile.query.QueryProfileBreakdown;
import org.opensearch.search.profile.query.QueryTimingType;

public final class ConcurrentQueryProfileBreakdown
extends ContextualProfileBreakdown {
    static final String SLICE_END_TIME_SUFFIX = "_slice_end_time";
    static final String SLICE_START_TIME_SUFFIX = "_slice_start_time";
    static final String MAX_PREFIX = "max_";
    static final String MIN_PREFIX = "min_";
    static final String AVG_PREFIX = "avg_";
    private long queryNodeTime = Long.MIN_VALUE;
    private long maxSliceNodeTime = Long.MIN_VALUE;
    private long minSliceNodeTime = Long.MAX_VALUE;
    private long avgSliceNodeTime = 0L;
    private final Map<Object, AbstractProfileBreakdown> contexts = new ConcurrentHashMap<Object, AbstractProfileBreakdown>();
    private final Map<Collector, List<LeafReaderContext>> sliceCollectorsToLeaves = new ConcurrentHashMap<Collector, List<LeafReaderContext>>();
    private final Collection<Supplier<ProfileMetric>> metricSuppliers;
    private final Set<String> timingMetrics;
    private final Set<String> nonTimingMetrics;

    public ConcurrentQueryProfileBreakdown(Collection<Supplier<ProfileMetric>> metricSuppliers) {
        super(metricSuppliers);
        this.metricSuppliers = metricSuppliers;
        this.timingMetrics = this.getTimingMetrics();
        this.nonTimingMetrics = this.getNonTimingMetrics();
    }

    @Override
    public AbstractProfileBreakdown context(Object context) {
        AbstractProfileBreakdown profile = this.contexts.get(context);
        if (profile != null) {
            return profile;
        }
        return this.contexts.computeIfAbsent(context, ctx -> new QueryProfileBreakdown(this.metricSuppliers));
    }

    @Override
    public Map<String, Long> toBreakdownMap() {
        Map<String, Long> topLevelBreakdownMapWithWeightTime = super.toBreakdownMap();
        long createWeightStartTime = topLevelBreakdownMapWithWeightTime.get(String.valueOf((Object)QueryTimingType.CREATE_WEIGHT) + "_start_time");
        long createWeightTime = topLevelBreakdownMapWithWeightTime.get(QueryTimingType.CREATE_WEIGHT.toString());
        if (this.contexts.isEmpty()) {
            this.queryNodeTime = createWeightTime;
            this.maxSliceNodeTime = 0L;
            this.minSliceNodeTime = 0L;
            this.avgSliceNodeTime = 0L;
            return this.buildDefaultQueryBreakdownMap(createWeightTime);
        }
        if (this.sliceCollectorsToLeaves.isEmpty()) {
            assert (this.contexts.size() == 1) : "Unexpected size: " + this.contexts.size() + " of leaves breakdown in ConcurrentQueryProfileBreakdown of rewritten query for a leaf.";
            AbstractProfileBreakdown breakdown = this.contexts.values().iterator().next();
            this.queryNodeTime = breakdown.toNodeTime() + createWeightTime;
            this.maxSliceNodeTime = 0L;
            this.minSliceNodeTime = 0L;
            this.avgSliceNodeTime = 0L;
            TreeMap<String, Long> queryBreakdownMap = new TreeMap<String, Long>(breakdown.toBreakdownMap());
            queryBreakdownMap.put(QueryTimingType.CREATE_WEIGHT.toString(), createWeightTime);
            queryBreakdownMap.put(String.valueOf((Object)QueryTimingType.CREATE_WEIGHT) + "_count", 1L);
            return queryBreakdownMap;
        }
        Map<Collector, Map<String, Long>> sliceLevelBreakdowns = this.buildSliceLevelBreakdown();
        return this.buildQueryBreakdownMap(sliceLevelBreakdowns, createWeightTime, createWeightStartTime);
    }

    private Map<String, Long> buildDefaultQueryBreakdownMap(long createWeightTime) {
        TreeMap<String, Long> concurrentQueryBreakdownMap = new TreeMap<String, Long>();
        for (QueryTimingType timingType : QueryTimingType.values()) {
            String timingTypeKey = timingType.toString();
            String timingTypeCountKey = String.valueOf((Object)timingType) + "_count";
            if (timingType.equals((Object)QueryTimingType.CREATE_WEIGHT)) {
                concurrentQueryBreakdownMap.put(timingTypeKey, createWeightTime);
                concurrentQueryBreakdownMap.put(timingTypeCountKey, 1L);
                continue;
            }
            String maxBreakdownTypeTime = MAX_PREFIX + String.valueOf((Object)timingType);
            String minBreakdownTypeTime = MIN_PREFIX + String.valueOf((Object)timingType);
            String avgBreakdownTypeTime = AVG_PREFIX + String.valueOf((Object)timingType);
            String maxBreakdownTypeCount = MAX_PREFIX + timingTypeCountKey;
            String minBreakdownTypeCount = MIN_PREFIX + timingTypeCountKey;
            String avgBreakdownTypeCount = AVG_PREFIX + timingTypeCountKey;
            concurrentQueryBreakdownMap.put(timingTypeKey, 0L);
            concurrentQueryBreakdownMap.put(maxBreakdownTypeTime, 0L);
            concurrentQueryBreakdownMap.put(minBreakdownTypeTime, 0L);
            concurrentQueryBreakdownMap.put(avgBreakdownTypeTime, 0L);
            concurrentQueryBreakdownMap.put(timingTypeCountKey, 0L);
            concurrentQueryBreakdownMap.put(maxBreakdownTypeCount, 0L);
            concurrentQueryBreakdownMap.put(minBreakdownTypeCount, 0L);
            concurrentQueryBreakdownMap.put(avgBreakdownTypeCount, 0L);
        }
        return concurrentQueryBreakdownMap;
    }

    Map<Collector, Map<String, Long>> buildSliceLevelBreakdown() {
        HashMap<Collector, Map<String, Long>> sliceLevelBreakdowns = new HashMap<Collector, Map<String, Long>>();
        long totalSliceNodeTime = 0L;
        for (Map.Entry<Collector, List<LeafReaderContext>> slice : this.sliceCollectorsToLeaves.entrySet()) {
            long currentSliceNodeTime;
            Collector sliceCollector = slice.getKey();
            Map currentSliceBreakdown = sliceLevelBreakdowns.computeIfAbsent(sliceCollector, k -> new HashMap());
            long sliceMaxEndTime = Long.MIN_VALUE;
            long sliceMinStartTime = Long.MAX_VALUE;
            for (String timingType : this.timingMetrics) {
                if (timingType.equals(QueryTimingType.CREATE_WEIGHT.toString())) continue;
                String timingTypeCountKey = timingType + "_count";
                String timingTypeStartKey = timingType + "_start_time";
                String timingTypeSliceStartTimeKey = timingType + SLICE_START_TIME_SUFFIX;
                String timingTypeSliceEndTimeKey = timingType + SLICE_END_TIME_SUFFIX;
                for (LeafReaderContext sliceLeaf : slice.getValue()) {
                    if (!this.contexts.containsKey(sliceLeaf)) continue;
                    Map<String, Long> currentSliceLeafBreakdownMap = this.contexts.get(sliceLeaf).toBreakdownMap();
                    long sliceLeafTimingTypeCount = currentSliceLeafBreakdownMap.get(timingTypeCountKey);
                    currentSliceBreakdown.compute(timingTypeCountKey, (key, value) -> value == null ? sliceLeafTimingTypeCount : value + sliceLeafTimingTypeCount);
                    if (sliceLeafTimingTypeCount == 0L) continue;
                    long sliceLeafTimingTypeStartTime = currentSliceLeafBreakdownMap.get(timingTypeStartKey);
                    currentSliceBreakdown.compute(timingTypeSliceStartTimeKey, (key, value) -> value == null ? sliceLeafTimingTypeStartTime : Math.min(value, sliceLeafTimingTypeStartTime));
                    long sliceLeafTimingTypeEndTime = sliceLeafTimingTypeStartTime + currentSliceLeafBreakdownMap.get(timingType);
                    currentSliceBreakdown.compute(timingTypeSliceEndTimeKey, (key, value) -> value == null ? sliceLeafTimingTypeEndTime : Math.max(value, sliceLeafTimingTypeEndTime));
                }
                if (currentSliceBreakdown.get(timingTypeCountKey) != null && (Long)currentSliceBreakdown.get(timingTypeCountKey) == 0L) {
                    currentSliceBreakdown.put(timingTypeSliceStartTimeKey, 0L);
                    currentSliceBreakdown.put(timingTypeSliceEndTimeKey, 0L);
                }
                sliceMaxEndTime = Math.max(sliceMaxEndTime, currentSliceBreakdown.getOrDefault(timingTypeSliceEndTimeKey, Long.MIN_VALUE));
                long currentSliceStartTime = currentSliceBreakdown.getOrDefault(timingTypeSliceStartTimeKey, Long.MAX_VALUE);
                if (currentSliceStartTime == 0L) continue;
                sliceMinStartTime = Math.min(sliceMinStartTime, currentSliceStartTime);
                currentSliceBreakdown.put(timingType, currentSliceBreakdown.getOrDefault(timingTypeSliceEndTimeKey, 0L) - currentSliceBreakdown.getOrDefault(timingTypeSliceStartTimeKey, 0L));
            }
            for (String metric : this.nonTimingMetrics) {
                for (LeafReaderContext sliceLeaf : slice.getValue()) {
                    if (!this.contexts.containsKey(sliceLeaf)) continue;
                    Map<String, Long> currentSliceLeafBreakdownMap = this.contexts.get(sliceLeaf).toBreakdownMap();
                    long sliceLeafMetricValue = currentSliceLeafBreakdownMap.get(metric);
                    currentSliceBreakdown.compute(metric, (key, value) -> value == null ? sliceLeafMetricValue : value + sliceLeafMetricValue);
                }
            }
            if (sliceMinStartTime == Long.MAX_VALUE && sliceMaxEndTime == Long.MIN_VALUE) {
                currentSliceNodeTime = 0L;
            } else {
                if (sliceMinStartTime == Long.MAX_VALUE || sliceMaxEndTime == Long.MIN_VALUE) {
                    throw new OpenSearchException("Unexpected value of sliceMinStartTime [" + sliceMinStartTime + "] or sliceMaxEndTime [" + sliceMaxEndTime + "] while computing the slice level timing profile breakdowns", new Object[0]);
                }
                currentSliceNodeTime = sliceMaxEndTime - sliceMinStartTime;
            }
            this.maxSliceNodeTime = Math.max(this.maxSliceNodeTime, currentSliceNodeTime);
            this.minSliceNodeTime = Math.min(this.minSliceNodeTime, currentSliceNodeTime);
            totalSliceNodeTime += currentSliceNodeTime;
        }
        this.avgSliceNodeTime = totalSliceNodeTime / (long)this.sliceCollectorsToLeaves.size();
        return sliceLevelBreakdowns;
    }

    public Map<String, Long> buildQueryBreakdownMap(Map<Collector, Map<String, Long>> sliceLevelBreakdowns, long createWeightTime, long createWeightStartTime) {
        TreeMap<String, Long> queryBreakdownMap = new TreeMap<String, Long>();
        long queryEndTime = Long.MIN_VALUE;
        queryBreakdownMap.put(String.valueOf((Object)QueryTimingType.CREATE_WEIGHT) + "_count", 1L);
        queryBreakdownMap.put(QueryTimingType.CREATE_WEIGHT.toString(), createWeightTime);
        for (String metric : this.timingMetrics) {
            if (metric.equals(QueryTimingType.CREATE_WEIGHT.toString())) continue;
            String timingTypeCountKey = metric + "_count";
            String sliceEndTimeForTimingType = metric + SLICE_END_TIME_SUFFIX;
            String sliceStartTimeForTimingType = metric + SLICE_START_TIME_SUFFIX;
            String maxBreakdownTypeTime = MAX_PREFIX + metric;
            String minBreakdownTypeTime = MIN_PREFIX + metric;
            String avgBreakdownTypeTime = AVG_PREFIX + metric;
            String maxBreakdownTypeCount = MAX_PREFIX + timingTypeCountKey;
            String minBreakdownTypeCount = MIN_PREFIX + timingTypeCountKey;
            String avgBreakdownTypeCount = AVG_PREFIX + timingTypeCountKey;
            long queryTimingTypeEndTime = Long.MIN_VALUE;
            long queryTimingTypeStartTime = Long.MAX_VALUE;
            long queryTimingTypeCount = 0L;
            for (Map.Entry<Collector, Map<String, Long>> sliceBreakdown : sliceLevelBreakdowns.entrySet()) {
                long sliceBreakdownTypeTime = sliceBreakdown.getValue().getOrDefault(metric, 0L);
                long sliceBreakdownTypeCount = sliceBreakdown.getValue().getOrDefault(timingTypeCountKey, 0L);
                this.addStatsToMap(queryBreakdownMap, maxBreakdownTypeTime, minBreakdownTypeTime, avgBreakdownTypeTime, sliceBreakdownTypeTime);
                this.addStatsToMap(queryBreakdownMap, maxBreakdownTypeCount, minBreakdownTypeCount, avgBreakdownTypeCount, sliceBreakdownTypeCount);
                if (sliceBreakdownTypeCount <= 0L) continue;
                queryTimingTypeEndTime = Math.max(queryTimingTypeEndTime, sliceBreakdown.getValue().getOrDefault(sliceEndTimeForTimingType, Long.MIN_VALUE));
                queryTimingTypeStartTime = Math.min(queryTimingTypeStartTime, sliceBreakdown.getValue().getOrDefault(sliceStartTimeForTimingType, Long.MAX_VALUE));
                queryTimingTypeCount += sliceBreakdownTypeCount;
            }
            if (queryTimingTypeCount > 0L && (queryTimingTypeStartTime == Long.MAX_VALUE || queryTimingTypeEndTime == Long.MIN_VALUE)) {
                throw new OpenSearchException("Unexpected timing type [" + metric + "] start [" + queryTimingTypeStartTime + "] or end time [" + queryTimingTypeEndTime + "] computed across slices for profile results", new Object[0]);
            }
            queryBreakdownMap.put(metric, queryTimingTypeCount > 0L ? queryTimingTypeEndTime - queryTimingTypeStartTime : 0L);
            queryBreakdownMap.put(timingTypeCountKey, queryTimingTypeCount);
            queryBreakdownMap.compute(avgBreakdownTypeTime, (key, value) -> value == null ? 0L : value / (long)sliceLevelBreakdowns.size());
            queryBreakdownMap.compute(avgBreakdownTypeCount, (key, value) -> value == null ? 0L : value / (long)sliceLevelBreakdowns.size());
            queryEndTime = Math.max(queryEndTime, queryTimingTypeEndTime);
        }
        for (String metric : this.nonTimingMetrics) {
            String maxBreakdownTypeTime = MAX_PREFIX + metric;
            String minBreakdownTypeTime = MIN_PREFIX + metric;
            String avgBreakdownTypeTime = AVG_PREFIX + metric;
            long totalBreakdownValue = 0L;
            for (Map.Entry<Collector, Map<String, Long>> sliceBreakdown : sliceLevelBreakdowns.entrySet()) {
                long sliceBreakdownValue = sliceBreakdown.getValue().getOrDefault(metric, 0L);
                this.addStatsToMap(queryBreakdownMap, maxBreakdownTypeTime, minBreakdownTypeTime, avgBreakdownTypeTime, sliceBreakdownValue);
                totalBreakdownValue += sliceBreakdownValue;
            }
            queryBreakdownMap.put(metric, totalBreakdownValue);
            queryBreakdownMap.compute(avgBreakdownTypeTime, (key, value) -> value == null ? 0L : value / (long)sliceLevelBreakdowns.size());
        }
        if (queryEndTime == Long.MIN_VALUE) {
            throw new OpenSearchException("Unexpected error while computing the query end time across slices in profile result", new Object[0]);
        }
        this.queryNodeTime = queryEndTime - createWeightStartTime;
        return queryBreakdownMap;
    }

    private void addStatsToMap(Map<String, Long> queryBreakdownMap, String maxKey, String minKey, String avgKey, long sliceValue) {
        queryBreakdownMap.compute(maxKey, (key, value) -> value == null ? sliceValue : Math.max(sliceValue, value));
        queryBreakdownMap.compute(minKey, (key, value) -> value == null ? sliceValue : Math.min(sliceValue, value));
        queryBreakdownMap.compute(avgKey, (key, value) -> value == null ? sliceValue : value + sliceValue);
    }

    private Set<String> getTimingMetrics() {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry entry : this.metrics.entrySet()) {
            if (!(entry.getValue() instanceof Timer)) continue;
            result.add((String)entry.getKey());
        }
        return result;
    }

    private Set<String> getNonTimingMetrics() {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry entry : this.metrics.entrySet()) {
            if (entry.getValue() instanceof Timer) continue;
            result.add((String)entry.getKey());
        }
        return result;
    }

    @Override
    public long toNodeTime() {
        return this.queryNodeTime;
    }

    @Override
    public void associateCollectorToLeaves(Collector collector, LeafReaderContext leaf) {
        this.sliceCollectorsToLeaves.computeIfAbsent(collector, k -> new ArrayList()).add(leaf);
    }

    @Override
    public void associateCollectorsToLeaves(Map<Collector, List<LeafReaderContext>> collectorsToLeaves) {
        this.sliceCollectorsToLeaves.putAll(collectorsToLeaves);
    }

    Map<Collector, List<LeafReaderContext>> getSliceCollectorsToLeaves() {
        return Collections.unmodifiableMap(this.sliceCollectorsToLeaves);
    }

    Map<Object, AbstractProfileBreakdown> getContexts() {
        return this.contexts;
    }

    long getMaxSliceNodeTime() {
        return this.maxSliceNodeTime;
    }

    long getMinSliceNodeTime() {
        return this.minSliceNodeTime;
    }

    long getAvgSliceNodeTime() {
        return this.avgSliceNodeTime;
    }
}

