/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.sort;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.sort.BucketedSort;
import org.opensearch.search.sort.ShardDocFieldComparatorSource;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortFieldAndFormat;
import org.opensearch.search.sort.SortOrder;

public class ShardDocSortBuilder
extends SortBuilder<ShardDocSortBuilder> {
    public static final String NAME = "_shard_doc";
    private static final ObjectParser<ShardDocSortBuilder, Void> PARSER = new ObjectParser("_shard_doc", ShardDocSortBuilder::new);

    public ShardDocSortBuilder() {
        this.order = SortOrder.ASC;
    }

    public ShardDocSortBuilder(StreamInput in) throws IOException {
        this.order = SortOrder.readFromStream(in);
    }

    public ShardDocSortBuilder(ShardDocSortBuilder other) {
        this.order = other.order;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.order.writeTo(out);
    }

    public static ShardDocSortBuilder fromXContent(XContentParser parser, String fieldName) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.FIELD_NAME) {
            token = parser.nextToken();
        }
        switch (token) {
            case START_OBJECT: {
                return (ShardDocSortBuilder)PARSER.parse(parser, null);
            }
            case VALUE_STRING: 
            case VALUE_NUMBER: 
            case VALUE_BOOLEAN: 
            case VALUE_NULL: {
                return new ShardDocSortBuilder();
            }
            case START_ARRAY: {
                throw new XContentParseException(parser.getTokenLocation(), "[_shard_doc] Expected START_OBJECT or scalar but was: START_ARRAY");
            }
        }
        throw new XContentParseException(parser.getTokenLocation(), "[_shard_doc] Expected START_OBJECT or scalar but was: " + String.valueOf(token));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(ORDER_FIELD.getPreferredName(), (Object)this.order);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    protected SortFieldAndFormat build(QueryShardContext context) {
        int shardId = context.getShardId();
        SortField sf = new SortField(NAME, (FieldComparatorSource)new ShardDocFieldComparatorSource(shardId), this.order == SortOrder.DESC);
        return new SortFieldAndFormat(sf, DocValueFormat.RAW);
    }

    @Override
    public BucketedSort buildBucketedSort(QueryShardContext context, int bucketSize, BucketedSort.ExtraData extra) throws IOException {
        throw new UnsupportedOperationException("bucketed sort not supported for _shard_doc");
    }

    @Override
    public ShardDocSortBuilder rewrite(QueryRewriteContext ctx) {
        return this;
    }

    public String getWriteableName() {
        return NAME;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShardDocSortBuilder other = (ShardDocSortBuilder)obj;
        return this.order == other.order;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.order});
    }

    static {
        PARSER.declareString((b, s) -> b.order(SortOrder.fromString(s)), ORDER_FIELD);
    }
}

