/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm.stats;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.wlm.stats.WorkloadGroupStats;

public class WlmStats
extends BaseNodeResponse
implements ToXContentObject,
Writeable {
    private final WorkloadGroupStats workloadGroupStats;

    public WlmStats(DiscoveryNode node, WorkloadGroupStats workloadGroupStats) {
        super(node);
        this.workloadGroupStats = workloadGroupStats;
    }

    public WlmStats(StreamInput in) throws IOException {
        super(in);
        this.workloadGroupStats = new WorkloadGroupStats(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.workloadGroupStats.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.workloadGroupStats.toXContent(builder, params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        WlmStats that = (WlmStats)((Object)o);
        return Objects.equals(this.getWorkloadGroupStats(), that.getWorkloadGroupStats());
    }

    public int hashCode() {
        return Objects.hash(this.workloadGroupStats);
    }

    public WorkloadGroupStats getWorkloadGroupStats() {
        return this.workloadGroupStats;
    }
}

