/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.mustache;

import java.io.IOException;
import java.util.Collections;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.ScriptType;
import org.opensearch.script.TemplateScript;
import org.opensearch.script.mustache.SearchTemplateRequest;
import org.opensearch.script.mustache.SearchTemplateResponse;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.node.NodeClient;

public class TransportSearchTemplateAction
extends HandledTransportAction<SearchTemplateRequest, SearchTemplateResponse> {
    private static final String TEMPLATE_LANG = "mustache";
    protected final ScriptService scriptService;
    protected final NamedXContentRegistry xContentRegistry;
    protected final NodeClient client;

    @Inject
    public TransportSearchTemplateAction(TransportService transportService, ActionFilters actionFilters, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NodeClient client) {
        super("indices:data/read/search/template", transportService, actionFilters, SearchTemplateRequest::new);
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
        this.client = client;
    }

    public TransportSearchTemplateAction(String actionName, TransportService transportService, ActionFilters actionFilters, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NodeClient client) {
        super(actionName, transportService, actionFilters, SearchTemplateRequest::new);
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
        this.client = client;
    }

    protected void doExecute(Task task, SearchTemplateRequest request, final ActionListener<SearchTemplateResponse> listener) {
        final SearchTemplateResponse response = new SearchTemplateResponse();
        try {
            SearchRequest searchRequest = TransportSearchTemplateAction.convert(request, response, this.scriptService, this.xContentRegistry);
            if (searchRequest != null) {
                this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse searchResponse) {
                        try {
                            response.setResponse(searchResponse);
                            listener.onResponse((Object)response);
                        }
                        catch (Exception t) {
                            listener.onFailure(t);
                        }
                    }

                    public void onFailure(Exception t) {
                        listener.onFailure(t);
                    }
                });
            } else {
                listener.onResponse((Object)response);
            }
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    static SearchRequest convert(SearchTemplateRequest searchTemplateRequest, SearchTemplateResponse response, ScriptService scriptService, NamedXContentRegistry xContentRegistry) throws IOException {
        Script script = new Script(searchTemplateRequest.getScriptType(), searchTemplateRequest.getScriptType() == ScriptType.STORED ? null : TEMPLATE_LANG, searchTemplateRequest.getScript(), searchTemplateRequest.getScriptParams() == null ? Collections.emptyMap() : searchTemplateRequest.getScriptParams());
        TemplateScript compiledScript = ((TemplateScript.Factory)scriptService.compile(script, TemplateScript.CONTEXT)).newInstance(script.getParams());
        String source = compiledScript.execute();
        response.setSource((BytesReference)new BytesArray(source));
        SearchRequest searchRequest = searchTemplateRequest.getRequest();
        if (searchTemplateRequest.isSimulate()) {
            return null;
        }
        try (XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, source);){
            SearchSourceBuilder builder = SearchSourceBuilder.searchSource();
            builder.parseXContent(parser, false);
            builder.explain(Boolean.valueOf(searchTemplateRequest.isExplain()));
            builder.profile(searchTemplateRequest.isProfile());
            TransportSearchTemplateAction.checkRestTotalHitsAsInt(searchRequest, builder);
            searchRequest.source(builder);
        }
        return searchRequest;
    }

    private static void checkRestTotalHitsAsInt(SearchRequest searchRequest, SearchSourceBuilder searchSourceBuilder) {
        Integer trackTotalHitsUpTo;
        if (searchRequest.source() == null) {
            searchRequest.source(new SearchSourceBuilder());
        }
        if ((trackTotalHitsUpTo = searchRequest.source().trackTotalHitsUpTo()) != null) {
            if (searchSourceBuilder.trackTotalHitsUpTo() == null) {
                searchSourceBuilder.trackTotalHitsUpTo(trackTotalHitsUpTo.intValue());
            } else if (searchSourceBuilder.trackTotalHitsUpTo() != Integer.MAX_VALUE && searchSourceBuilder.trackTotalHitsUpTo() != -1) {
                throw new IllegalArgumentException("[rest_total_hits_as_int] cannot be used if the tracking of total hits is not accurate, got " + searchSourceBuilder.trackTotalHitsUpTo());
            }
        }
    }
}

