/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.ir;

import org.opensearch.painless.ClassWriter;
import org.opensearch.painless.Location;
import org.opensearch.painless.MethodWriter;
import org.opensearch.painless.ir.UnaryNode;
import org.opensearch.painless.lookup.PainlessLookupUtility;
import org.opensearch.painless.lookup.def;
import org.opensearch.painless.phase.IRTreeVisitor;
import org.opensearch.painless.symbol.WriteScope;

public class InstanceofNode
extends UnaryNode {
    private Class<?> instanceType;

    public void setInstanceType(Class<?> instanceType) {
        this.instanceType = instanceType;
    }

    public Class<?> getInstanceType() {
        return this.instanceType;
    }

    public String getInstanceCanonicalTypeName() {
        return PainlessLookupUtility.typeToCanonicalTypeName(this.instanceType);
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitInstanceof(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        this.getChildNode().visit(irTreeVisitor, scope);
    }

    public InstanceofNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        this.getChildNode().write(classWriter, methodWriter, writeScope);
        if (this.instanceType == def.class) {
            methodWriter.writePop(MethodWriter.getType(this.getExpressionType()).getSize());
            methodWriter.push(true);
        } else if (this.getChildNode().getExpressionType().isPrimitive()) {
            methodWriter.writePop(MethodWriter.getType(this.getExpressionType()).getSize());
            methodWriter.push(PainlessLookupUtility.typeToBoxedType(this.instanceType).isAssignableFrom(PainlessLookupUtility.typeToBoxedType(this.getChildNode().getExpressionType())));
        } else {
            methodWriter.instanceOf(MethodWriter.getType(PainlessLookupUtility.typeToBoxedType(this.instanceType)));
        }
    }
}

